<%@include file="../common/taglibs.jsp" %>

<c:if test="${empty requestScope.note.breederTopiaId}">
    <jsp:forward page="/appli/breeder/list.do"/>
</c:if>

<html>
    
    <body>
        <%@include file="../common/header.jsp" %>
        
        <div class="content">
            <div class="subtitle"><fmt:message key="note.new.title"/> : ${requestScope.breeder.title}</div>
            <br class="spacer bigspace"/>
            
            <div class="align-right space">
                <html:link styleClass="button go" action="/appli/breeder/note/list.do" paramId="topiaId" paramName="note" paramProperty="breederTopiaId">
                    <fmt:message key="note.list.title"/>
                </html:link>
                <html:link styleClass="button go" action="/appli/breeder/view.do" paramId="topiaId" paramName="note" paramProperty="breederTopiaId">
                    <fmt:message key="breeder.view.title"/>
                </html:link>
            </div>
            <br class="spacer"/>
            
            <html:form action="/appli/breeder/note/save" method="POST" enctype="multipart/form-data">
                <html:hidden property="topiaId"/>
                <html:hidden property="breederTopiaId"/>
                <input type="hidden" name="filename" value=""/>

                <div class="leftPart">
                    <label for="description"><fmt:message key="note.description"/><span class="required">*</span> :</label>
                </div>
                <div class="rightPart">
                    <html:textarea property="description" styleId="description" styleClass="fixed2"/>
                </div>
                <br class="spacer"/>

                <div class="leftPart">
                    <label for="file"><fmt:message key="note.file"/><span class="required">*</span> :</label>
                </div>
                <div class="rightPart">
                    <html:file property="file" styleId="file"/>
                </div>
                <br class="spacer"/>

                <div class="groupbutton">
                    <html:submit styleClass="save" property="save" onclick="form.filename.value=form.file.value.toString()"><fmt:message key="common.save"/></html:submit>
                </div>
                <div class="clear">&nbsp;</div>
            </html:form>

        </div>
        <%@include file="../common/footer.jsp" %>
    </body>
    
</html>
