<%@include file="../common/taglibs.jsp" %>

<c:if test="${empty requestScope.breeder.topiaId}">
    <jsp:forward page="/appli/breeder/list.do"/>
</c:if>

<html>
    
    <body>
        <%@include file="../common/header.jsp" %>
        
        <div class="content">
            <div class="subtitle"><fmt:message key="note.list.title"/> : ${requestScope.breeder.title}</div>
            
            <div class="align-right space">
                <s:authorization expression="com.cybelia.sandra.entities.Note#*" actions="CREATE">
                    <html:link styleClass="button add" action="/appli/breeder/note/view.do" paramId="breederTopiaId" paramName="breeder" paramProperty="topiaId">
                        <fmt:message key="common.new"/>
                    </html:link>
                </s:authorization>
                <html:link styleClass="button go" action="/appli/breeder/list.do">
                    <fmt:message key="breeder.list.title"/>
                </html:link>
                <html:link styleClass="button go" action="/appli/breeder/view.do" paramId="topiaId" paramName="breeder" paramProperty="topiaId">
                    <fmt:message key="breeder.view.title"/>
                </html:link>
            </div>
            <br class="spacer"/>
            
            <display:table name="requestScope.breeder.notes" id="note" requestURI="/appli/breeder/note/select.do" sort="list" defaultsort="1" defaultorder="ascending" pagesize="25">
                <display:column titleKey="note.preview" class="colcenter">
                    <c:url var="url" value="/appli/breeder/note/image.do">
                        <c:param name="note" value="${note.topiaId}"/>
                        <c:param name="width" value="120"/>
                        <c:param name="height" value="120"/>
                    </c:url>
                    <html:link action="/appli/breeder/note/file.do" paramId="note" paramName="note" paramProperty="topiaId">
                        <object data="${url}" type="${note.contentType}">
                          <img src="<c:url value='/images/nopreview.gif'/>" alt="<fmt:message key="common.title"/>"/>
                        </object>
                    </html:link>
                </display:column>
                <display:column property="nom" titleKey="note.name" sortable="true"/>
                <display:column property="description" titleKey="note.description" sortable="true"/>
                <display:column titleKey="common.action" class="action">
                    <s:authorization expression="com.cybelia.sandra.entities.Note#*" actions="DELETE">
                        <html:link styleClass="button delete" action="/appli/breeder/note/delete.do" paramId="note" paramName="note" paramProperty="topiaId">
                            <fmt:message key="common.delete"/>
                        </html:link>
                    </s:authorization>
                    <html:link styleClass="button download" action="/appli/breeder/note/download.do" paramId="note" paramName="note" paramProperty="topiaId">
                        <fmt:message key="note.download.title"/>
                    </html:link>
                    <html:link styleClass="button view" action="/appli/breeder/note/file.do" paramId="note" paramName="note" paramProperty="topiaId">
                        <fmt:message key="note.file.title"/>
                    </html:link>
                </display:column>
            </display:table>
        </div>
        
        <%@include file="../common/footer.jsp" %>
    </body>
    
</html>
