<%@include file="../common/taglibs.jsp" %>

<c:if test="${empty requestScope.note.breeder.topiaId}">
    <jsp:forward page="/appli/breeder/list.do"/>
</c:if>

<html>
    
    <body>
        <%@include file="../common/header.jsp" %>
        
        <div class="content">
            
            <div class="subtitle"><fmt:message key="note.file.title"/> : ${requestScope.breeder.title}</div>
            <br class="spacer bigspace"/>

            <div class="align-right space">
                <html:link styleClass="button go" action="/appli/breeder/note/list.do" paramId="topiaId" paramName="note" paramProperty="breederTopiaId">
                    <fmt:message key="note.list.title"/>
                </html:link>
                <html:link styleClass="button go" action="/appli/breeder/view.do" paramId="topiaId" paramName="note" paramProperty="breederTopiaId">
                    <fmt:message key="breeder.view.title"/>
                </html:link>
            </div>
            <br class="spacer"/>

            <div>
                <c:url var="url" value="/appli/breeder/note/image.do">
                    <c:param name="note" value="${requestScope.note.topiaId}"/>
                    <c:param name="width" value="640"/>
                    <c:param name="height" value="480"/>
                </c:url>

                <object data="${url}" type="${requestScope.note.contentType}">
                    <div class="subsubtitle">
                        <fmt:message key="note.file.noopen"/> :
                        <html:link styleClass="button download" action="/appli/breeder/note/download.do" paramId="note" paramName="note" paramProperty="topiaId">
                            <fmt:message key="note.download.title"/>
                        </html:link>
                    </div>
                </object>
            </div>
            <div>
                ${requestScope.note.description}
            </div>

        </div>
        <%@include file="../common/footer.jsp" %>
    </body>
    
</html>
