<%@include file="../common/taglibs.jsp"%>

<s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion, com.cybelia.sandra.entities.Societe"/>

<html>
    <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8"/>

        <script src="${applicationSession.googleMapKey}"  type="text/javascript"></script>

        <script type="text/javascript">
            var marker;
            function load(blat, blng) {
                if (GBrowserIsCompatible()) {
                    var center = new GLatLng(blat, blng);

                    var map = new GMap2(document.getElementById("map"));
                    map.addControl(new GSmallMapControl());
                    map.addControl(new GMapTypeControl());
                    map.addControl(new GScaleControl());
                    map.setCenter(center, 13);

                    marker = new GMarker(center, {draggable: true});
                    map.addOverlay(marker);

                    GEvent.addListener(map,"click", function() {
                        marker.closeInfoWindow();
                    });

                        <c:choose>
                        <c:when test="${requestScope.infoAccess.etat == 1}">
                        marker.disableDragging();
                        </c:when>
                        <c:otherwise>
                        GEvent.addListener(marker, "dragstart", function() {
                        map.closeInfoWindow();
                    });

                    GEvent.addListener(marker, "dragend", function() {
                        var latlng = marker.getLatLng();
                        var longitude = document.getElementById("longitude");
                        ;
                        var latitude = document.getElementById("latitude");
                        ;

                        longitude.value = latlng.lng();
                        latitude.value = latlng.lat();
                    });
                        </c:otherwise>
                        </c:choose>
                    }
            }
            function help(){
                alert ("<fmt:message key="silo.risque.help"/>");
            }
        </script>
    </head>
    <body onload="load(${requestScope.infoAccess.latitude}, ${requestScope.infoAccess.longitude})" onunload="GUnload()">
        <%@include file="../common/header.jsp"%>

        <div class="content">
            <div class="subtitle">
                <c:if test="${not empty requestScope.infoAccess.topiaId}">
                    <fmt:message key="infoAccess.modify.title"/> : ${requestScope.infoAccess.nomAccess} 
                    <br/>
                    ${requestScope.breeder.raisonSociale} (${requestScope.breeder.societe.code}-${requestScope.breeder.code}) ${requestScope.breeder.ville}
                </c:if>
            </div>
            <div>
                <c:if test="${requestScope.infoAccess.etat == 0}">

                    <s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion">
                        <html:form action="/appli/breeder/infoAccess/lock" method="POST">
                            <html:hidden property="topiaId"/>
                            <html:hidden property="etat"/>
                            <html:submit styleClass="save"><fmt:message key="silo.lock"/></html:submit>
                        </html:form>
                    </s:principal>

                </c:if>
                <c:if test="${requestScope.infoAccess.etat == 1}">
                    <s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion">
                        <html:link styleClass="button save" action="/appli/breeder/infoAccess/unlock.do" paramId="topiaId" paramName="infoAccess" paramProperty="topiaId"><fmt:message key="silo.unlock"/></html:link>
                    </s:principal>

                    <s:principal name="admin-com.cybelia.sandra.entities.Societe" inverse="true">
                        <html:link styleClass="button save" action="/appli/breeder/infoAccess/requestToUnlockFromSilo.do" paramId="topiaId" paramName="infoAccess" paramProperty="topiaId"><fmt:message key="silo.request"/></html:link>
                   </s:principal>
                </c:if>
            </div>
            <div class="align-right float-right space">
                <html:link styleClass="button go" action="/appli/breeder/list.do">
                    <fmt:message key="breeder.list.title"/>
                </html:link>
                <html:link styleClass="button go" action="/appli/breeder/view.do" paramId="topiaId" paramName="breeder" paramProperty="topiaId">
                    <fmt:message key="breeder.view.title"/>
                </html:link>
            </div>

            <br class="spacer"/>

            <c:if test="${requestScope.infoAccess.etat != 3}">
                <html:form action="/appli/breeder/infoAccess/save" method="POST">
                    <div class="leftFormulaireSilo">
                        <html:hidden property="topiaId"/>
                        <html:hidden property="eleveurTopiaId"/>

                        <div class="leftSiloPart">
                            <label for="nomAccess"><fmt:message key="silo.nom"/> :</label>
                        </div>
                        <div class="rightPart">
                            <html:text disabled="true" property="nomAccess" styleId="nomAccess" size="20" maxlength="20" styleClass="expend2"/>
                        </div>
                        <br class="spacer"/>

                        <div class="leftSiloPart">
                            <label for="accesSilo"><fmt:message key="silo.acces.silo"/> :</label>
                        </div>
                        <div class="rightPart" id="accesSilo" >
                            <html:select disabled="${requestScope.infoAccess.etat == 1}" property="accesSilo" styleClass="expend2">
                                <html:option value="" key="naming.no"/>
                                <html:optionsCollection name="applicationSession" property="namingLabelAccessSilos" label="value" value="key"/>
                            </html:select>
                        </div>
                        <br class="spacer"/>

                        <div class="leftSiloPart">
                            <label for="modeChargement"><fmt:message key="silo.acces.equipement"/> :</label>
                        </div>
                        <div id="modeChargement" class="rightPart">
                            <html:select disabled="${requestScope.infoAccess.etat == 1}" property="modeChargement" styleClass="expend2">
                                <html:option value="" key="naming.no"/>
                                <html:optionsCollection name="applicationSession" property="namingLabelEquipements" label="value" value="key"/>
                            </html:select>
                        </div>
                        <br class="spacer"/>

                        <div class="leftSiloPart">
                            <label for="niveauSecurite"><fmt:message key="silo.securityLevel"/> :</label>
                        </div>
                        <div class="rightPart secu">
                            <html:radio disabled="${requestScope.infoAccess.etat == 1}" property="niveauSecurite" styleId="niveauSecurite" value="-1">
                                <fmt:message key="silo.no"/>
                            </html:radio>
                            <html:radio disabled="${requestScope.infoAccess.etat == 1}" property="niveauSecurite" styleId="niveauSecurite" value="1">
                                <img src="<c:url value="/images/silo_vert.jpg"/>"/>
                            </html:radio>
                            <html:radio disabled="${requestScope.infoAccess.etat == 1}" property="niveauSecurite" styleId="niveauSecurite" value="2">
                                <img src="<c:url value="/images/silo_orange.jpg"/>"/>
                            </html:radio>
                            <html:radio disabled="${requestScope.infoAccess.etat == 1}" property="niveauSecurite" styleId="niveauSecurite" value="3">
                                <img src="<c:url value="/images/silo_rouge.jpg"/>"/>
                            </html:radio>
                            <html:radio disabled="${requestScope.infoAccess.etat == 1}" property="niveauSecurite" styleId="niveauSecurite" value="4">
                                <img src="<c:url value="/images/silo_gris.jpg"/>"/>
                            </html:radio>
                        </div>
                        <br class="spacer"/>

                        <div class="leftSiloPart">
                            <label for="risk"><fmt:message key="silo.risk"/> :</label>
                        </div>
                        <div id="risk" class="rightPart">
                            <c:forEach var='risk' items="${applicationSession.namingLabelRisques}">
                                <input type=checkbox 
                                       <c:if test="${requestScope.infoAccess.etat == 1}">
                                    disabled
                                </c:if>
                                name="risques" value="${risk.key}"
                                <c:forEach var='rsk' items="${requestScope.infoAccess.risques}">
                                    <c:if test="${risk.key == rsk}">
                                        checked
                                    </c:if>
                                </c:forEach>
                                ><s:label categorie="RSK" id="${risk.key}"/>
                                <br/>
                            </c:forEach>
                        </div>
                        <br class="spacer"/>

                        <div class="leftSiloPart">
                            <label for="commentSecurite"><fmt:message key="silo.commentSecu"/> :</label>
                        </div>
                        <div class="rightPart">
                            <html:textarea disabled="${requestScope.infoAccess.etat == 1}" property="commentSecurite" styleId="commentSecurite" styleClass="expend2"/>
                        </div>
                        <br class="spacer"/>
                    </div>


                    <div class="rightSiloMap">
                        <div class="rightPart subsubtitle">
                            <fmt:message key="breeder.map"/>
                        </div>
                        <br class="spacer"/>

                        <div class="rightPart">
                            <div id="map" class="mapSilo">&nbsp;</div>
                        </div>
                        <br class="spacer"/>

                        <div class="leftSiloGroupbutton">

                            <div class="leftSiloPart">
                                <label for="latitude"><fmt:message key="breeder.latitude"/> :</label>
                            </div>
                            <div class="rightPart">
                                <html:text disabled="${requestScope.infoAccess.etat == 1}" property="latitude" styleId="latitude" size="20" maxlength="50" styleClass="expend2" onchange="load(form.latitude.value, form.longitude.value)"/>
                            </div>
                            <br class="spacer"/>

                            <div class="leftSiloPart">
                                <label for="longitude"><fmt:message key="breeder.longitude"/> :</label>
                            </div>
                            <div class="rightPart">
                                <html:text disabled="${requestScope.infoAccess.etat == 1}" property="longitude" styleId="longitude" size="20" maxlength="50" styleClass="expend2" onchange="load(form.latitude.value, form.longitude.value)"/>
                            </div>
                            <br class="spacer"/>
                            <html:submit disabled="${requestScope.infoAccess.etat == 1}" styleClass="save" property="save"><fmt:message key="common.save"/></html:submit>
                        </div>
                        <div class="clear">&nbsp;</div>

                    </div>
                </html:form>
            </c:if>
            <c:if test="${requestScope.infoAccess.etat == 2}">
                <fmt:message key="silo.isdeleted"/>
            </c:if>
        </div>
        <%@include file="../common/footer.jsp"%>
    </body>

</html>
