<%@include file="../common/taglibs.jsp" %>

<s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion, com.cybelia.sandra.entities.Societe"/>

<c:if test="${empty requestScope.breeder.topiaId}">
    <jsp:forward page="/appli/breeder/list.do"/>
</c:if>

<html>
    <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8"/>

        <script src="${applicationSession.googleMapKey}"  type="text/javascript"></script>

        <script type="text/javascript">
            var marker;
            function load(blat, blng) {
                if (GBrowserIsCompatible()) {
                    var center = new GLatLng(blat, blng);

                    var map = new GMap2(document.getElementById("map"));
                    map.addControl(new GSmallMapControl());
                    map.addControl(new GMapTypeControl());
                    map.addControl(new GScaleControl());
                    map.setCenter(center, 13);

                    marker = new GMarker(center, {draggable: true});
                    map.addOverlay(marker);

                    GEvent.addListener(map,"click", function() {
                        marker.closeInfoWindow();
                    });

                    //marker.openInfoWindowHtml("<fmt:message key="breeder.map.description"/>");
                    GEvent.addListener(marker, "click", function() {
                        marker.openInfoWindowHtml("${requestScope.breeder.raisonSociale}<br>${requestScope.breeder.adresse}<br>${requestScope.breeder.codePostal} ${requestScope.breeder.ville}");
                    });

                        <c:choose>
                        <c:when test="${requestScope.breeder.tomTomGPSLocked}">
                        marker.disableDragging();
                        </c:when>
                        <c:otherwise>
                        GEvent.addListener(marker, "dragstart", function() {
                        map.closeInfoWindow();
                    });

                    GEvent.addListener(marker, "dragend", function() {
                        var latlng = marker.getLatLng();
                        var longitude = document.getElementById("longitude");
                        var latitude = document.getElementById("latitude");

                        longitude.value = latlng.lng();
                        latitude.value = latlng.lat();
                    });
                        </c:otherwise>
                        </c:choose>
                    }
            }
            function help(){
                marker.openInfoWindowHtml("<fmt:message key="breeder.map.description"/>");
            }
        </script>
    </head>

    <body onload="load(${requestScope.breeder.latitude}, ${requestScope.breeder.longitude})" onunload="GUnload()">
        <%@include file="../common/header.jsp" %>

        <div class="content">
            <div class="subtitle"><fmt:message key="breeder.view.title"/> : ${requestScope.breeder.title}</div>

            <div class="align-right space">
                <html:link styleClass="button go" action="/appli/breeder/list.do">
                    <fmt:message key="breeder.list.title"/>
                </html:link>
                <html:link styleClass="button go" action="/appli/breeder/note/list.do" paramId="topiaId" paramName="breeder" paramProperty="topiaId">
                    <fmt:message key="note.list.title"/>
                </html:link>
                <s:principal name="admin-com.cybelia.sandra.entities.Societe, com.cybelia.sandra.entities.Societe">
                    <html:link styleClass="button go" action="/appli/breeder/action/list.do" paramId="breederTopiaId" paramName="breeder" paramProperty="topiaId">
                        <fmt:message key="action.list"/>
                    </html:link>
                </s:principal>
                <s:principal name="admin, TPS, thierry.pons">
                    <html:link styleClass="button go" action="/appli/breeder/registerBreederAsDuplicated.do" paramId="topiaId" paramName="breeder" paramProperty="topiaId"><fmt:message key="breeder.markAsDuplicated"/></html:link>
                </s:principal>
            </div>
            <br class="spacer"/>

            <fieldset class="redFieldset">
                <legend align=top><fmt:message key="breeder.legend"/></legend>
                <div class="leftEleveurFormulaire">
                    <div class="rightPart">
                        <s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion, com.cybelia.sandra.entities.Societe">
                            <html:link styleClass="button go" action="/appli/breeder/edit.do" paramId="topiaId" paramName="breeder" paramProperty="topiaId"><fmt:message key="common.edit"/></html:link>
                        </s:principal>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurPart">
                        <label for="telephone"><fmt:message key="breeder.telephone"/> :</label>
                    </div>
                    <div class="rightEleveurPart" id="telephone">
                        <c:if test="${not empty requestScope.breeder.telephone}">
                            ${requestScope.breeder.telephone},
                        </c:if>
                        <c:if test="${not empty requestScope.breeder.mobile}">
                            ${requestScope.breeder.mobile}          
                        </c:if>
                    </div>
                    <br class="spacer"/>

                    <c:if test="${not empty requestScope.breeder.email}">
                        <div class="leftEleveurPart">
                            <label for="email"><fmt:message key="breeder.email"/> :</label>
                        </div>
                        <div class="rightEleveurPart" id="email">
                            ${requestScope.breeder.email}
                        </div>
                        <br class="spacer"/>
                    </c:if>

                    <div class="leftEleveurPart">
                        <label for="address"><fmt:message key="breeder.address"/> :</label>
                    </div>
                    <div class="rightEleveurPart" id="address">
                        ${requestScope.breeder.adresse} ${requestScope.breeder.codePostal} ${requestScope.breeder.ville}
                    </div>
                    <br class="spacer"/>

                    <c:if test="${not empty requestScope.breeder.contrainteHoraire}">
                        <div class="leftEleveurPart">
                            <label for="time"><fmt:message key="breeder.time"/> :</label>
                        </div>
                        <div class="rightEleveurPart" id="time">
                            <s:label categorie="ECH" id="${requestScope.breeder.contrainteHoraire}"/>
                        </div>
                        <br class="spacer"/>
                    </c:if>

                    <c:if test="${not empty requestScope.breeder.commentaire}">
                        <div class="leftEleveurPart">
                            <label for="comment"><fmt:message key="breeder.comment"/> :</label>
                        </div>
                        <div class="rightEleveurPart" id="comment">
                            ${requestScope.breeder.commentaire}
                        </div>
                        <br class="spacer"/>
                    </c:if>

                    <c:if test="${not empty requestScope.breeder.accesEleveur}">

                        <c:if test="${not empty requestScope.breeder.accesEleveur.accesSilo}">
                            <div class="leftEleveurPart">
                                <label for="accesEquipementSilo"><fmt:message key="breeder.acces.silo"/> :</label>
                            </div>
                            <div class="rightEleveurPart" id="accesEquipementSilo">
                                <s:label categorie="IAS" id="${requestScope.breeder.accesEleveur.accesSilo}"/>,&nbsp;
                            </div>
                            <br class="spacer"/>
                        </c:if>
                        <c:if test="${not empty requestScope.breeder.accesEleveur.modeChargement}">
                            <div class="leftEleveurPart">
                                <label for="accesEquipementSilo"><fmt:message key="breeder.acces.chargement"/> :</label>
                            </div>
                            <div class="rightEleveurPart" id="accesEquipementSilo">
                                <s:label categorie="IMC" id="${requestScope.breeder.accesEleveur.modeChargement}"/>
                            </div>
                        </c:if>
                        <br class="spacer"/>

                        <div class="leftEleveurPart">
                            <label for="security"><fmt:message key="breeder.security"/> :</label>
                        </div>
                        <div class="rightEleveurPart" id="security">
                            <c:if test="${requestScope.breeder.niveauSecurite == -1}">
                                <fmt:message key="silo.noSecurityLevel"/>
                            </c:if>
                            <c:if test="${requestScope.breeder.niveauSecurite == 1}">
                                <img src="<c:url value="/images/silo_vert.jpg"/>"/>
                            </c:if>
                            <c:if test="${requestScope.breeder.niveauSecurite == 2}">
                                <img src="<c:url value="/images/silo_orange.jpg"/>"/>
                            </c:if>
                            <c:if test="${requestScope.breeder.niveauSecurite == 3}">
                                <img src="<c:url value="/images/silo_rouge.jpg"/>"/>
                            </c:if>
                            <c:if test="${requestScope.breeder.niveauSecurite == 4}">
                                <img src="<c:url value="/images/silo_gris.jpg"/>"/>
                            </c:if>
                        </div>
                        <br class="spacer"/>

                        <c:if test="${not empty requestScope.breeder.accesEleveur.risques}">
                            <div class="leftEleveurPart">
                                <label for="risques"><fmt:message key="breeder.risques"/>&nbsp;&nbsp;&nbsp;</label>
                            </div>
                            <div class="rightEleveurPart" id="risques">
                                <ul>
                                    <c:forEach items="${requestScope.breeder.accesEleveur.risques}" var="risk">
                                        <li><s:label categorie="RSK" id="${risk}"/></li>
                                    </c:forEach>
                                </ul>
                            </div>
                            <br class="spacer"/>
                        </c:if>

                        <c:if test="${not empty requestScope.breeder.commentSecurite}">
                            <div class="leftEleveurPart">
                                <label for="commentSecu"><fmt:message key="breeder.commentSecu"/> :</label>
                            </div>
                            <div class="rightEleveurPart" id="commentSecu">
                                ${requestScope.breeder.commentSecurite}
                            </div>
                            <br class="spacer"/>
                        </c:if>
                    </c:if>
                    <c:if test="${empty requestScope.breeder.accesEleveur}">
                        <html:errors property="accesEleveur"/>
                    </c:if>
                    <br class="spacer"/>

                    <c:if test="${not empty requestScope.actions}">
                        <s:principal name="admin-com.cybelia.sandra.entities.Societe, com.cybelia.sandra.entities.Societe">
                            <display:table name="requestScope.actions" id="action" requestURI="/appli/breeder/action/listLess.do">
                                <display:column titleKey="action.type" class="colcenter">
                                    <s:label categorie="ACT" id="${action.type}"/>
                                </display:column>
                                <display:column titleKey="action.dateAction" class="colcenter">
                                    <fmt:formatDate value="${action.dateAction}" pattern="${date_pattern_long}"/>
                                </display:column>
                                <display:column titleKey="action.commentaire" class="colcenter">
                                    ${action.commentaire}
                                </display:column>
                                <display:column titleKey="action.silo" class="colcenter">
                                    ${action.infoAccess.nomAcces}
                                </display:column>
                            </display:table>
                        </s:principal>
                    </c:if>

                </div>
                <div class="rightMap">
                    <div class="rightPart subsubtitle">
                        <fmt:message key="breeder.map"/>
                    </div>

                    <br class="spacer"/>
                    <div class="rightMapPart">
                        <div id="map" class="mapBreeder">&nbsp;</div>
                        <div class="leftGPSPart">
                            <html:form action="/appli/breeder/gps/save" method="POST" styleId="saveGPS">
                                <html:hidden property="topiaId"/>

                                <label for="latitude"><fmt:message key="breeder.latitude"/><span class="required">*</span> :</label>
                                <html:text disabled="${requestScope.breeder.tomTomGPSLocked}" property="latitude" styleId="latitude" size="20" maxlength="50" onchange="load(form.latitude.value, form.longitude.value)"/>
                                &nbsp;&nbsp;
                                <label for="longitude"><fmt:message key="breeder.longitude"/><span class="required">*</span> :</label>
                                <html:text disabled="${requestScope.breeder.tomTomGPSLocked}" property="longitude" styleId="longitude" size="20" maxlength="50" onchange="load(form.latitude.value, form.longitude.value)"/>
                            </html:form>
                        </div>
                        <div class="leftIco">
                            <c:choose>
                                <c:when test="${requestScope.breeder.tomTomGPSLocked}">
                                    &nbsp;&nbsp;<img src="<c:url value="/images/tom-tom-small-blue-block.jpg"/>"/>
                                </c:when>
                                <c:when test="${not requestScope.breeder.hasTomTomGPS}">
                                    &nbsp;&nbsp;<img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                                </c:when>
                                <c:otherwise>
                                    &nbsp;&nbsp;<img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                                </c:otherwise>
                            </c:choose>
                        </div>
                        <div class="rightGPSPart">
                            <c:if test="${not requestScope.breeder.tomTomGPSLocked}">
                                <div class="left">
                                    <s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion, com.cybelia.sandra.entities.Societe">
                                        <s:authorization expression="com.cybelia.sandra.entities.sig.PointGPS#*" actions="CREATE, UPDATE, DELETE">
                                            <html:button styleClass="save" property="save" onclick="document.getElementById('saveGPS').submit();"><fmt:message key="common.save"/></html:button>
                                        </s:authorization>
                                    </s:principal>
                                </div>
                            </c:if>
                            <c:choose>
                                <c:when test="${requestScope.breeder.tomTomGPSLocked}">
                                    <s:principal name="admin-com.cybelia.sandra.entities.Societe">
                                        <div class="left">
                                            <html:form action="/appli/breeder/gps/lock" method="POST">
                                                <html:hidden property="topiaId"/>
                                                <html:hidden property="tomTomGPSLocked"/>
                                                <html:submit styleClass="save" property="unlock"><fmt:message key="common.unlock"/></html:submit>
                                            </html:form>
                                        </div>
                                    </s:principal>
                                    <s:principal name="admin-com.cybelia.sandra.entities.Societe" inverse="true">
                                        <div class="left">
                                            <html:form action="/appli/breeder/gps/request" method="POST">
                                                <html:hidden property="topiaId"/>
                                                <html:submit styleClass="go" property="request"><fmt:message key="breeder.gps.request"/></html:submit>
                                            </html:form>
                                        </div>
                                    </s:principal>
                                </c:when>
                                <c:otherwise>
                                    <s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion, com.cybelia.sandra.entities.Societe">
                                        <div class="left">
                                            <html:form action="/appli/breeder/gps/lock" method="POST">
                                                <html:hidden property="topiaId"/>
                                                <html:hidden property="tomTomGPSLocked"/>
                                                <html:submit styleClass="save" property="lock"><fmt:message key="common.lock"/></html:submit>
                                            </html:form>
                                        </div>
                                    </s:principal>
                                </c:otherwise>
                            </c:choose>
                            <div class="right">
                                <html:button styleClass="help" property="help" onclick="javascript:help();"><fmt:message key="common.help"/></html:button>
                            </div>
                        </div>
                    </div>
                    <div class="rightNotes">
                        <c:forEach items="${requestScope.breeder.notes}" var="note">
                            <html:link action="/appli/breeder/note/file.do" paramId="note" paramName="note" paramProperty="topiaId">
                                <c:url var="url" value="/appli/breeder/note/image.do">
                                    <c:param name="note" value="${note.topiaId}"/>
                                    <c:param name="width" value="120"/>
                                    <c:param name="height" value="120"/>
                                </c:url>
                                <object data="${url}" type="${note.contentType}" title="${note.description}">
                                    <img src="<c:url value='/images/nopreview.gif'/>" alt="<fmt:message key="common.title"/>"/>
                                </object>
                            </html:link>
                            <br class="spacer"/>
                        </c:forEach>
                    </div>
                </div>
            </fieldset>
            <fieldset class="redFieldset">
                <legend align=top><fmt:message key="silo.legend"/></legend>
                <div class="clear">
                    <display:table name="requestScope.accesSilos" id="silo" defaultsort="1" requestURI="/appli/breeder/view.do">
                        <c:if test="${silo.etat != 2}">
                            <display:column titleKey="silo.nom" sortable="true" sortProperty="nomAcces">
                                ${silo.nomAcces}
                            </display:column>
                            <display:column titleKey="silo.gps" sortable="true" sortProperty="gps" class="colcenter">
                                <c:choose>
                                    <c:when test="${empty silo.gps}">
                                        <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                                    </c:when>
                                    <c:otherwise>
                                        <c:choose>
                                            <c:when test="${silo.gps.point.x == 0}">
                                                <c:choose>
                                                    <c:when test="${silo.gps.point.y == 0}">
                                                        <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                                                    </c:when>
                                                    <c:otherwise>
                                                        <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                                                    </c:otherwise>
                                                </c:choose>
                                            </c:when>
                                            <c:otherwise>
                                                <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:otherwise>
                                </c:choose>
                            </display:column>
                            <display:column titleKey="silo.acces.silo" sortable="true" sortProperty="accesSilo">
                                <s:label categorie="IAS" id="${silo.accesSilo}"/>
                            </display:column>
                            <display:column titleKey="silo.acces.equipement" sortable="true" sortProperty="modeChargement">
                                <s:label categorie="IMC" id="${silo.modeChargement}"/>
                            </display:column>
                            <display:column titleKey="silo.securityLevel" sortable="true" sortProperty="niveauSecurite" class="colcenter">
                                <c:if test="${silo.niveauSecurite == -1}">
                                    <fmt:message key="silo.noSecurityLevel"/>
                                </c:if>
                                <c:if test="${silo.niveauSecurite == 1}">
                                    <img src="<c:url value="/images/silo_vert.jpg"/>"/>
                                </c:if>
                                <c:if test="${silo.niveauSecurite == 2}">
                                    <img src="<c:url value="/images/silo_orange.jpg"/>"/>
                                </c:if>
                                <c:if test="${silo.niveauSecurite == 3}">
                                    <img src="<c:url value="/images/silo_rouge.jpg"/>"/>
                                </c:if>
                                <c:if test="${silo.niveauSecurite == 4}">
                                    <img src="<c:url value="/images/silo_gris.jpg"/>"/>
                                </c:if>
                            </display:column>
                            <display:column titleKey="silo.risk">
                                <c:forEach items="${silo.risques}" var="risk">
                                    <s:label categorie="RSK" id="${risk}"/>
                                    <br/>
                                </c:forEach>
                            </display:column>
                            <display:column titleKey="silo.commentSecu">
                                ${silo.commentaireSecurite}
                            </display:column>
                            <display:column titleKey="common.action" class="colright action" media="html">
                                <c:if test="${silo.etat == 1}">
                                    <s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion, com.cybelia.sandra.entities.Societe">
                                        <html:link styleClass="button save" action="/appli/breeder/infoAccess/unlock.do" paramId="topiaId" paramName="silo" paramProperty="topiaId"><fmt:message key="silo.unlock"/></html:link>
                                    </s:principal>

                                    <s:principal name="admin-com.cybelia.sandra.entities.Societe" inverse="true">

                                        <%
                                            java.util.HashMap params = new java.util.HashMap();
                                                params.put("topiaId", ((com.cybelia.sandra.web.action.breeder.BreederForm)request.getAttribute("breeder")).getTopiaId());
                                                params.put("infoaccess", ((org.nuiton.topia.persistence.TopiaEntity)pageContext.getAttribute("silo")).getTopiaId());
                                                pageContext.setAttribute("tempParams", params);
                                        %>

                                        <bean:define var="URL" id="url" type="java.lang.String"/>

                                        <html:link styleClass="button save" action="/appli/breeder/infoAccess/requestToUnlock.do" name="tempParams"><fmt:message key="silo.request"/></html:link>
                                   </s:principal>
                                    <s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion, com.cybelia.sandra.entities.Societe">
                                        <html:link styleClass="button go" action="/appli/breeder/infoAccess/view.do" paramId="topiaId" paramName="silo" paramProperty="topiaId"><fmt:message key="common.view"/></html:link>
                                    </s:principal>
                                </c:if>
                                <c:if test="${silo.etat == 0}">
                                    <s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion, com.cybelia.sandra.entities.Societe">
                                        <html:link styleClass="button go" action="/appli/breeder/infoAccess/view.do" paramId="topiaId" paramName="silo" paramProperty="topiaId"><fmt:message key="common.edit"/></html:link>
                                    </s:principal>
                                    <s:principal name="admin, TPS, thierry.pons">
                                        <html:link styleClass="button delete" action="/appli/breeder/infoAccess/delete.do" paramId="topiaId" paramName="silo" paramProperty="topiaId"><fmt:message key="common.delete"/></html:link>
                                    </s:principal>
                                </c:if>
                            </display:column>
                        </c:if>
                    </display:table>
                </div>
            </fieldset>
        </div>
        <%@include file="../common/footer.jsp" %>
    </body>

</html>