<%@include file="../common/taglibs.jsp" %>

<html>
    <body>
        <%@include file="../common/header.jsp" %>
<script>
$(document).ready(function(){
    $('#livraisonDate').datepicker();
});
</script>
        <div class="content">
            <c:if test="${empty requestScope.breederDuplicatedTopiaId}">
                <div class="subtitle"><fmt:message key="breeder.list.title"/></div>
            </c:if>
            <c:if test="${not empty requestScope.breederDuplicatedTopiaId}">
                <div class="subtitle"><fmt:message key="breeder.searchDuplicated.title"/></div>
            </c:if>

            <div class="align-right space">
                <s:principal name="admin-com.cybelia.sandra.entities.Societe">
                    <html:link styleClass="button email" action="/appli/breeder/sendDangerousBreederEmail.do"><fmt:message key="user.sendDangerousBreederEmail"/></html:link>
                </s:principal>
            </div>
            <div class="space">
                <html:form action="/appli/breeder/search" method="POST" styleId="searchBreader">
                    <html:hidden property="eleveurDuplicated"/>

                    <div class="criteria">
                        <div>
                            <label for="query"><fmt:message key="breeder.criteria.query"/> :</label>
                        </div>
                        <div>
                            <html:text property="query" size="50" styleId="query"/>
                        </div>
                    </div>

                    <div class="criteria">
                        <div>
                            <label for="gpsKey"><fmt:message key="breeder.criteria.gps"/> :</label>
                        </div>
                        <div  id="gpsKey">
                            <html:select property="gpsKey">
                                <html:option value="" key="naming.no"/>
                                <html:optionsCollection name="applicationSession" property="gpsStates" label="value" value="key"/>
                            </html:select>
                        </div>
                    </div>

                    <div class="criteria">
                        <div>&nbsp;</div>
                        <html:select property="operator">
                            <html:option value="" key="naming.no"/>
                            <html:optionsCollection name="applicationSession" property="operators" label="value" value="key"/>
                        </html:select>
                    </div>

                    <div class="criteria">
                        <div>
                            <label for="nivSecu"><fmt:message key="breeder.criteria.nivSecu"/> :</label>
                        </div>
                        <div id="nivSecu" >
                            <html:select property="nivSecu">
                                <html:option value="" key="naming.no"/>
                                <html:optionsCollection name="applicationSession" property="nivSecu" label="value" value="key"/>
                            </html:select>
                        </div>
                    </div>

                    <div class="criteria">
                        <div>
                            <label for="livraisonDate"><fmt:message key="breeder.criteria.livraisonDate"/> :</label>
                        </div>
                        <div>
                            <fmt:formatDate value="${criteria.livraisonDate}" var="livraisonDate" pattern="${date_pattern_long}"/>
                            <html:text property="livraisonDate" styleId="livraisonDate" size="8" maxlength="8" value="${livraisonDate}"/>
                        </div>
                    </div>

                    <div class="criteria">
                        <div>
                            <label for="society"><fmt:message key="breeder.criteria.society"/> :</label>
                        </div>
                        <div>
                            <html:select property="societe" styleId="society">
                                <html:option value="" key="naming.no"/>
                                <html:optionsCollection name="applicationSession" property="namingSocietes" label="value" value="key"/>
                            </html:select>
                        </div>
                    </div>

                    <div class="criteria">
                        <div>
                            <label for="truck"><fmt:message key="breeder.criteria.truck"/> :</label>
                        </div>
                        <div>
                            <html:select property="camion" styleId="truck">
                                <html:option value="" key="naming.no"/>
                                <html:optionsCollection name="applicationSession" property="namingCamionsActifs" label="value" value="key"/>
                            </html:select>
                        </div>
                    </div>
                    <div class="criteria">
                        <div>&nbsp;</div>
                        <html:submit styleClass="search"><fmt:message key="breeder.search"/></html:submit>
                    </div>
                </html:form>
            </div>
            <br class="spacer"/>
            
            <html:form action="/appli/breeder/breederDuplicatedSelected" method="POST">
                <html:hidden property="eleveurDuplicated"/>
                <display:table name="requestScope.breeders" id="breeder" requestURI="/appli/breeder/search.do">
                    <c:if test="${not empty requestScope.breederDuplicatedTopiaId}">
                        <display:column titleKey="breeder.select" class="colcenter">
                            <html:radio property="eleveur" value="${breeder.topiaId}"/>
                        </display:column>
                    </c:if>
                    <display:column titleKey="breeder.raisonSociale" class="colcenter" property="raisonSociale"/>
                    <display:column titleKey="breeder.society" class="colcenter">
                        <s:naming topiaId="${breeder.societe.topiaId}"/>
                    </display:column>
                    <display:column titleKey="breeder.code" class="colcenter" property="code"/>
                    <display:column titleKey="breeder.address" class="colcenter">
                        ${breeder.adresse} ${breeder.codePostal} ${breeder.ville}
                    </display:column>
                    <display:column titleKey="breeder.gps" class="colcenter">
                        <c:choose>
                            <c:when test="${breeder.nbTomTomGPSModif > 3}">
                                <img src="<c:url value="/images/tom-tom-small-blue-block.jpg"/>"/>
                            </c:when>
                            <c:when test="${empty breeder.tomtomGPS}">
                                <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                            </c:when>
                            <c:otherwise>
                                <c:choose>
                                    <c:when test="${breeder.tomtomGPS.point.x == 0}">
                                        <c:choose>
                                            <c:when test="${breeder.tomtomGPS.point.y == 0}">
                                                <img src="<c:url value="/images/tom-tom-small.jpg"/>"/>
                                            </c:when>
                                            <c:otherwise>
                                                <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:when>
                                    <c:otherwise>
                                        <img src="<c:url value="/images/tom-tom-small-blue.jpg"/>"/>
                                    </c:otherwise>
                                </c:choose>
                            </c:otherwise>
                        </c:choose>
                    </display:column>
                    <display:column titleKey="breeder.security" sortable="true" sortProperty="niveauSecurite" class="colcenter">
                        <c:if test="${breeder.accesEleveur.niveauSecurite == -1}">
                            <fmt:message key="silo.noSecurityLevel"/>
                        </c:if>
                        <c:if test="${breeder.accesEleveur.niveauSecurite == 1}">
                            <img src="<c:url value="/images/silo_vert.jpg"/>"/>
                        </c:if>
                        <c:if test="${breeder.accesEleveur.niveauSecurite == 2}">
                            <img src="<c:url value="/images/silo_orange.jpg"/>"/>
                        </c:if>
                        <c:if test="${breeder.accesEleveur.niveauSecurite == 3}">
                            <img src="<c:url value="/images/silo_rouge.jpg"/>"/>
                        </c:if>
                        <c:if test="${breeder.accesEleveur.niveauSecurite == 4}">
                            <img src="<c:url value="/images/silo_gris.jpg"/>"/>
                        </c:if>
                    </display:column>
                    <display:column titleKey="breeder.risques" class="colcenter">
                        <ul>
                            <c:forEach items="${breeder.accesEleveur.risques}" var="risk">
                                <li style="list-style-type : none;"><s:label categorie="RSK" id="${risk}"/></li>
                            </c:forEach>
                        </ul>
                    </display:column>
                    <c:if test="${empty requestScope.breederDuplicatedTopiaId}">
                        <display:column titleKey="common.action" class="action">
                            <html:link styleClass="button go"
                                       action="/appli/tour/traceability/searchByBreader.do"
                                       paramId="breederTopiaId"
                                       paramName="breeder"
                                       paramProperty="topiaId">
                                <fmt:message key="traceability.list.title"/>
                            </html:link>
                            <html:link styleClass="button go"
                                       action="/appli/breeder/view.do"
                                       paramId="topiaId"
                                       paramName="breeder"
                                       paramProperty="topiaId">
                                <fmt:message key="breeder.view.title"/>
                            </html:link>
                            <html:link styleClass="button go"
                                       action="/appli/breeder/note/list.do"
                                       paramId="topiaId"
                                       paramName="breeder"
                                       paramProperty="topiaId">
                                <fmt:message key="note.list.title"/>
                            </html:link>
                        </display:column>
                    </c:if>
                </display:table>
                <c:if test="${not empty requestScope.breederDuplicatedTopiaId}">
                    <html:submit>
                        <fmt:message key="breeder.search.select"/>
                    </html:submit>
                </c:if>
            </html:form>
        </div>
        <%@include file="../common/footer.jsp" %>
    </body>
    
</html>
