<%@include file="../common/taglibs.jsp" %>

<s:principal name="admin-com.cybelia.sandra.entities.Societe, admin-com.cybelia.sandra.entities.Transporteur, admin-com.cybelia.sandra.entities.Chauffeur, admin-com.cybelia.sandra.entities.Camion, com.cybelia.sandra.entities.Societe"/>

<c:if test="${empty requestScope.breeder.topiaId}">
    <jsp:forward page="/appli/breeder/list.do"/>
</c:if>

<html>
    <head>
        <meta http-equiv="content-type" content="text/html; charset=utf-8"/>

        <script type="text/javascript">
            function help(){
                alert("<fmt:message key="silo.risque.help"/>");
            }
        </script>
    </head>
    <body>
        <%@include file="../common/header.jsp" %>
        
        <div class="content">
            <div class="subtitle"><fmt:message key="breeder.edit.title"/> : ${requestScope.breeder.title}</div>
            
            <div class="align-right space">
                <html:link styleClass="button go" action="/appli/breeder/list.do">
                    <fmt:message key="breeder.list.title"/>
                </html:link>
                <html:link styleClass="button go" action="/appli/breeder/view.do" paramId="topiaId" paramName="breeder" paramProperty="topiaId">
                    <fmt:message key="breeder.view.title"/>
                </html:link>
                <!--html:link styleClass="button go" action="/appli/breeder/security/list.do" paramId="topiaId" paramName="breeder" paramProperty="topiaId"-->
                    <!--fmt:message key="securite.list.title"/-->
                <!--/html:link-->
            </div>
            <br class="spacer"/>

            <html:form action="/appli/breeder/save" method="POST">

                <div class="leftEleveurEditFormulaire">
                    <html:hidden property="topiaId"/>
                    <html:hidden property="accesTopiaId"/>
                    <html:hidden property="society"/>
                    <div class="leftEleveurEditPart">
                        <label for="raisonSociale"><fmt:message key="breeder.raisonSociale"/> :</label>
                    </div>
                    <div class="rightPart" id="raisonSociale">
                        <html:text property="raisonSociale" styleId="raisonSociale" maxlength="20" styleClass="fixed4"/>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="telephone"><fmt:message key="breeder.telephone"/> :</label>
                    </div>
                    <div class="rightPart" id="telephone">
                        <html:text property="telephone" styleId="telephone" size="20" maxlength="20" styleClass="fixed4"/>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="mobile"><fmt:message key="breeder.mobile"/> :</label>
                    </div>
                    <div class="rightPart" id="mobile">
                        <html:text property="mobile" styleId="mobile" size="20" maxlength="20" styleClass="fixed4"/>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="email"><fmt:message key="breeder.email"/> :</label>
                    </div>
                    <div class="rightPart" id="email">
                        <html:text property="email" styleId="email" maxlength="20" styleClass="fixed4"/>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="address"><fmt:message key="breeder.address"/> :</label>
                    </div>
                    <div class="rightPart" id="address">
                        <html:text property="adresse" styleId="adresse" maxlength="20" styleClass="fixed4"/>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="codePostal"><fmt:message key="breeder.codePostal"/> :</label>
                    </div>
                    <div class="rightPart" id="codePostal">
                        <html:text property="codePostal" styleId="codePostal" size="20" maxlength="20" styleClass="fixed4"/>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="ville"><fmt:message key="breeder.ville"/> :</label>
                    </div>
                    <div class="rightPart" id="ville">
                        <html:text property="ville" styleId="ville" maxlength="20" styleClass="fixed4"/>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="time"><fmt:message key="breeder.time"/> :</label>
                    </div>
                    <div class="rightPart" id="time">
                        <html:select property="contrainteHoraire" styleClass="fixed4">
                            <html:option value="" key="naming.no"/>
                            <html:optionsCollection name="applicationSession" property="namingTime" label="value" value="key"/>
                        </html:select>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="comment"><fmt:message key="breeder.comment"/> :</label>
                    </div>
                    <div class="rightPart" id="comment">
                        <html:textarea property="commentaire" styleId="commentaire" styleClass="fixed4"/>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="accesSilo"><fmt:message key="silo.acces.silo"/> :</label>
                    </div>
                    <div id="accesSilo" class="rightPart">
                        <html:select property="accesSilo" styleClass="fixed4">
                            <html:option value="" key="naming.no"/>
                            <html:optionsCollection name="applicationSession" property="namingLabelAccessSilos" label="value" value="key"/>
                        </html:select>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="modeChargement"><fmt:message key="silo.acces.equipement"/> :</label>
                    </div>
                    <div id="modeChargement" class="rightPart">
                        <html:select property="modeChargement" styleClass="fixed4">
                            <html:option value="" key="naming.no"/>
                            <html:optionsCollection name="applicationSession" property="namingLabelEquipements" label="value" value="key"/>
                        </html:select>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurEditPart">
                        <label for="commentSecurite"><fmt:message key="breeder.commentSecu"/> :</label>
                    </div>
                    <div class="rightPart">
                        <html:textarea property="commentSecurite" styleId="commentSecurite" styleClass="fixed4"/>
                    </div>
                    <br class="spacer"/>
                </div>

                <div class="rightPartRiskEditEleveur">

                    <div class="leftEleveurRiskPart">
                        <label for="accessNiveauSecurite"><fmt:message key="silo.securityLevel"/> :</label>
                    </div>
                    <div id="accessNiveauSecurite" class="rightPart secu">
                        <html:radio property="accessNiveauSecurite" styleId="accessNiveauSecurite" value="-1">
                            <fmt:message key="silo.no"/>
                        </html:radio>
                        <html:radio property="accessNiveauSecurite" styleId="accessNiveauSecurite" value="1">
                            <img src="<c:url value="/images/silo_vert.jpg"/>"/>
                        </html:radio>
                        <html:radio property="accessNiveauSecurite" styleId="accessNiveauSecurite" value="2">
                            <img src="<c:url value="/images/silo_orange.jpg"/>"/>
                        </html:radio>
                        <html:radio property="accessNiveauSecurite" styleId="accessNiveauSecurite" value="3">
                            <img src="<c:url value="/images/silo_rouge.jpg"/>"/>
                        </html:radio>
                        <html:radio property="accessNiveauSecurite" styleId="accessNiveauSecurite" value="4">
                            <img src="<c:url value="/images/silo_gris.jpg"/>"/>
                        </html:radio>
                    </div>
                    <br class="spacer"/>

                    <div class="leftEleveurRiskPart">
                        <label for="risk"><fmt:message key="silo.risk"/> :</label>
                    </div>

                    <div class="rightRiskPart">
                        <div id="risk" class="leftRisk">
                            <c:forEach var='risk' items="${applicationSession.namingLabelRisques}" varStatus="vs">
                                <c:if test="${vs.index == fn:length(applicationSession.namingLabelRisques) / 2}">
                                    </div>
                                    <div class="rightRiskEditEleveur">
                                </c:if>
                                <input type=checkbox name="risques" value="${risk.key}" 
                                        <c:forEach var='rsk' items="${requestScope.breeder.risques}">
                                            <c:if test="${risk.key == rsk}">
                                               checked
                                            </c:if>
                                        </c:forEach>
                                        ><s:label categorie="RSK" id="${risk.key}"/>
                                <br/>
                            </c:forEach>
                        </div>
                    </div>
                    <br class="spacer"/>

                    <div class="leftGroupbutton">
                        <html:submit styleClass="save" property="save"><fmt:message key="common.save"/></html:submit>
                    </div>

                </div>
                <div class="clear">&nbsp;</div>

            </html:form>
        </div>
        <%@include file="../common/footer.jsp" %>
    </body>
    
</html>
