/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.taglib;

import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.StatutEnum;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.trace.CREtape;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.loading.model.LoadingTable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TourTagLib
extends TagSupport {
    private static final long serialVersionUID = 1L;
    protected final Log log = LogFactory.getLog(this.getClass());
    public static String INCIDENT_ANOMALY = "tour.incident.anomaly";
    public static String INCIDENT_NOTHING = "tour.incident.nothing";
    public static String INCIDENT_ALLNOTHING = "tour.incident.allnothing";
    private Tour tour;
    private String method;

    public void setTour(Tour tour) {
        this.tour = tour;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    private double round(double value) {
        return (double)Math.round(value * 10.0) / 10.0;
    }

    public int doStartTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            if (this.method.equalsIgnoreCase("driver")) {
                SuiviTour suiviTour = this.tour.getSuiviTour();
                Chauffeur chauffeur = null;
                if (suiviTour != null) {
                    String nomPrenom;
                    chauffeur = suiviTour.getReel();
                    if (chauffeur == null && (nomPrenom = suiviTour.getChauffeurNomPrenom()) != null) {
                        out.print(nomPrenom);
                    }
                } else {
                    chauffeur = this.tour.getDefautChauffeur();
                }
                if (chauffeur != null) {
                    String prenom;
                    String nom = chauffeur.getNom();
                    if (nom != null) {
                        out.print(nom);
                        out.print(" ");
                    }
                    if ((prenom = chauffeur.getPrenom()) != null) {
                        out.print(prenom);
                    }
                }
            } else if (this.method.equalsIgnoreCase("factories")) {
                SuiviTour suiviTour = this.tour.getSuiviTour();
                if (suiviTour != null) {
                    for (SuiviUsine suiviUsine : suiviTour.getSuiviUsines()) {
                        out.print(suiviUsine.getUsine().getCode() + " ");
                    }
                } else {
                    HashSet<String> usines = new HashSet<String>();
                    List etapes = this.tour.getEtapes();
                    for (Etape etape : etapes) {
                        List produits = etape.getProduits();
                        for (LigneProduit produit : produits) {
                            String code = produit.getUsine().getCode();
                            usines.add(code);
                        }
                    }
                    for (String usine : usines) {
                        out.print(usine + " ");
                    }
                }
            } else if (this.method.equalsIgnoreCase("incident")) {
                SuiviTour suiviTour = this.tour.getSuiviTour();
                this.pageContext.setAttribute("tourIncident", (Object)INCIDENT_NOTHING);
                if (suiviTour != null) {
                    boolean ras = true;
                    for (SuiviEtape suiviEtape : suiviTour.getSuiviEtapes()) {
                        CREtape crEtape = suiviEtape.getCREtape();
                        if (crEtape != null) {
                            if ("RAS".equalsIgnoreCase(crEtape.getLivraisonStatut().trim())) continue;
                            ras = false;
                            this.pageContext.setAttribute("tourIncident", (Object)INCIDENT_ANOMALY);
                            continue;
                        }
                        ras = false;
                    }
                    if (ras) {
                        this.pageContext.setAttribute("tourIncident", (Object)INCIDENT_ALLNOTHING);
                    }
                }
            } else if (this.method.equalsIgnoreCase("quantity")) {
                List etapes = this.tour.getEtapes();
                int quantityTotal = 0;
                for (Etape etape : etapes) {
                    List ligneProduits = etape.getProduits();
                    for (LigneProduit ligneProduit : ligneProduits) {
                        quantityTotal += ligneProduit.getQuantiteACharger();
                    }
                }
                Double quantityTotalInTonne = new Double(quantityTotal) / 1000.0;
                quantityTotalInTonne = this.round(quantityTotalInTonne.doubleValue());
                out.print(quantityTotalInTonne + "T ");
            } else if (this.method.equalsIgnoreCase("dateChargement")) {
                SuiviTour suiviTour = this.tour.getSuiviTour();
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                Date result = this.tour.getDateChargement();
                if (suiviTour != null) {
                    Date olderDate = null;
                    for (SuiviUsine suiviUsine : suiviTour.getSuiviUsines()) {
                        Date dateChargementPrevue = suiviUsine.getDateChargementPrevue();
                        if (olderDate != null && !olderDate.after(dateChargementPrevue) || dateChargementPrevue.getTime() <= 0L) continue;
                        olderDate = dateChargementPrevue;
                    }
                    if (olderDate != null) {
                        result = olderDate;
                    }
                }
                out.print(format.format(result));
            } else if (this.method.equalsIgnoreCase("status")) {
                StatutEnum statut = null;
                SuiviTour suiviTour = this.tour.getSuiviTour();
                ArrayList produits = new ArrayList();
                if (suiviTour != null) {
                    if (suiviTour.getStatus() == LoadingTable.TOUR_STATUS_DELIVERY) {
                        statut = StatutEnum.EN_COURS_LIVRAISON;
                    }
                    if (suiviTour.getStatus() == LoadingTable.TOUR_STATUS_TERMINED) {
                        statut = StatutEnum.TERMINE;
                    }
                    if (statut == null) {
                        List suiviEtapes = suiviTour.getSuiviEtapes();
                        for (SuiviEtape suiviEtape : suiviEtapes) {
                            Etape etape = suiviEtape.getEtape();
                            if (etape == null) continue;
                            produits.addAll(etape.getProduits());
                        }
                    }
                }
                List etapes = this.tour.getEtapes();
                for (Etape etape : etapes) {
                    produits.addAll(etape.getProduits());
                }
                statut = this.getStatutSteps(produits);
                ApplicationSession applicationSession = ApplicationSession.get((HttpSession)this.pageContext.getSession());
                Map naming = applicationSession.getNamingLabels();
                String nanming = (String)naming.get("CHA:" + statut.getCode());
                out.print(nanming);
            } else {
                out.print("??error??");
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    private StatutEnum getStatutSteps(List<LigneProduit> produits) {
        StatutEnum statut = null;
        boolean oneAvailable = false;
        boolean allAvailable = true;
        boolean oneCharged = false;
        for (LigneProduit produit : produits) {
            oneAvailable |= produit.getDisponible();
            allAvailable &= produit.getDisponible();
            oneCharged |= produit.getInfoChargement().getQuantite() > 0;
        }
        statut = oneCharged ? StatutEnum.CHARGE : (allAvailable ? StatutEnum.DISPONIBLE : (oneAvailable ? StatutEnum.SEMI_DISPONIBLE : StatutEnum.PLANIFIE));
        return statut;
    }
}

