/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.taglib;

import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class StepTagLib
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private Etape etape;
    private String method;

    public void setEtape(Etape etape) {
        this.etape = etape;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    private double round(double value) {
        return (double)Math.round(value * 10.0) / 10.0;
    }

    public int doStartTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            if (this.method.equalsIgnoreCase("quantity")) {
                int quantityTotal = 0;
                if (this.etape != null) {
                    List ligneProduits = this.etape.getProduits();
                    for (LigneProduit ligneProduit : ligneProduits) {
                        quantityTotal += ligneProduit.getQuantiteACharger();
                    }
                    Double quantityTotalInTonne = new Double(quantityTotal) / 1000.0;
                    quantityTotalInTonne = this.round(quantityTotalInTonne.doubleValue());
                    out.print(quantityTotalInTonne + "T ");
                }
            } else {
                out.print("??error??");
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }
}

