/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.taglib;

import com.cybelia.sandra.entities.LigneProduit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProductCommentIteratorTagLib
extends TagSupport {
    private static final Log log = LogFactory.getLog(ProductCommentIteratorTagLib.class);
    protected List<LigneProduit> products;
    protected List<String> comments;
    protected int i;

    public void setProducts(List<LigneProduit> products) {
        this.products = products;
        this.comments = new ArrayList();
        this.i = 0;
    }

    protected String nextComment() throws JspTagException {
        String comment = "";
        LigneProduit currentProduct = (LigneProduit)this.products.get(this.i);
        String currentComment = currentProduct.getCommande().getCommentaire();
        boolean unique = true;
        for (String c : this.comments) {
            if (!c.trim().equals(currentComment.trim())) continue;
            unique = false;
        }
        if (unique) {
            comment = comment + currentComment;
        }
        this.comments.add(currentComment);
        ++this.i;
        return comment;
    }

    protected boolean hasNext() throws JspTagException {
        return this.i < this.products.size();
    }

    public int doStartTag() throws JspTagException {
        int result = 0;
        if (this.hasNext()) {
            String currentComment = this.nextComment();
            JspWriter out = this.pageContext.getOut();
            try {
                out.println(currentComment);
            }
            catch (IOException ex) {
                log.error((Object)("Cant display comment : " + currentComment), (Throwable)ex);
            }
            result = 2;
        }
        return result;
    }

    public int doAfterBody() throws JspTagException {
        return this.doStartTag();
    }
}

