/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.displaytag;

import com.cybelia.sandra.web.displaytag.PaginedListExtractor;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.properties.SortOrderEnum;

public class PaginedListImpl<E>
implements PaginatedList,
Serializable {
    protected static final Log log = LogFactory.getLog(PaginedListImpl.class);
    protected transient List<E> list;
    protected int pageNumber;
    protected int objectsPerPage;
    protected Integer fullListSize;
    protected String sortCriterion;
    protected String requestPrefix = "";
    protected transient SortOrderEnum sortDirection;
    protected String searchId;
    protected PaginedListExtractor<E> extractor;
    private static final long serialVersionUID = -77286294984699702L;

    public PaginedListImpl(int fullListSize, List<E> list) {
        this(null);
        this.fullListSize = fullListSize;
        this.list = list;
    }

    public PaginedListImpl(PaginedListExtractor<E> extractor) {
        this.extractor = extractor;
        this.pageNumber = 1;
        this.objectsPerPage = 25;
        this.sortDirection = SortOrderEnum.ASCENDING;
    }

    public PaginedListImpl(PaginedListExtractor<E> extractor, int objectsPerPage, String requestPrefix, String sortCriterion, SortOrderEnum sortDirection) {
        this.extractor = extractor;
        this.objectsPerPage = objectsPerPage;
        this.requestPrefix = requestPrefix;
        this.sortCriterion = sortCriterion;
        this.sortDirection = sortDirection;
        this.pageNumber = 1;
    }

    public List<E> getList() {
        return this.list;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getObjectsPerPage() {
        return this.objectsPerPage;
    }

    public int getFullListSize() {
        return this.fullListSize;
    }

    public String getSortCriterion() {
        return this.sortCriterion;
    }

    public SortOrderEnum getSortDirection() {
        return this.sortDirection;
    }

    public String getSearchId() {
        return this.searchId;
    }

    public void setList(List<E> list) {
        this.list = list;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setObjectsPerPage(int objectsPerPage) {
        this.objectsPerPage = objectsPerPage;
    }

    public void setFullListSize(Integer fullListSize) {
        this.fullListSize = fullListSize;
    }

    public void setSortCriterion(String sortCriterion) {
        this.sortCriterion = sortCriterion;
    }

    public void setSortDirection(SortOrderEnum sortDirection) {
        this.sortDirection = sortDirection;
    }

    public void setSearchId(String searchId) {
        this.searchId = searchId;
    }

    public void setRequestPrefix(String requestPrefix) {
        this.requestPrefix = requestPrefix;
    }

    public PaginedListImpl<E> fromRequest(HttpServletRequest request) {
        String direction;
        String criterion;
        String page = request.getParameter(this.requestPrefix + "page");
        if (page != null && !page.trim().isEmpty()) {
            Integer pageNumber1 = Integer.valueOf(page);
            if (log.isDebugEnabled()) {
                log.debug((Object)("change pageNumber : " + pageNumber1));
            }
            this.setPageNumber(pageNumber1.intValue());
        }
        if ((criterion = request.getParameter(this.requestPrefix + "sort")) != null && !criterion.trim().isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("change sortCriterion : " + criterion));
            }
            this.setSortCriterion(criterion);
        }
        if ((direction = request.getParameter(this.requestPrefix + "dir")) != null && !direction.trim().isEmpty()) {
            SortOrderEnum orderEnum = SortOrderEnum.fromName((String)direction);
            if (log.isDebugEnabled()) {
                log.debug((Object)("change sortDirection : " + orderEnum));
            }
            this.setSortDirection(orderEnum);
        }
        return this;
    }

    public PaginedListImpl<E> acquireData(HttpServletRequest request) throws Exception {
        if (this.fullListSize == null) {
            this.setFullListSize(Integer.valueOf(this.extractor.getFullListSize(request)));
        }
        if (this.fullListSize == 0) {
            this.setList(null);
        } else {
            int startIndex = (this.pageNumber - 1) * this.objectsPerPage;
            int endIndex = startIndex + this.objectsPerPage - 1;
            if (endIndex > this.fullListSize) {
                endIndex = this.fullListSize;
            }
            this.setList(this.extractor.getList(request, startIndex, endIndex, this.sortCriterion, this.sortDirection.getCode()));
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("<pageNumber:");
        builder.append(this.pageNumber);
        builder.append(", objectsPerPage:");
        builder.append(this.objectsPerPage);
        builder.append(", fulListSize:");
        builder.append(this.fullListSize);
        builder.append(", sortCriterion:");
        builder.append(this.sortCriterion);
        builder.append(", sortDirection:");
        builder.append(this.sortDirection);
        builder.append(">");
        return builder.toString();
    }
}

