/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.converter;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.Converter;
import org.apache.log4j.Logger;

public class DateConverter
implements Converter {
    private static final Logger log = Logger.getLogger(DateConverter.class);
    private Object defaultValue = null;

    public DateConverter() {
        this.defaultValue = null;
    }

    public DateConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            return this.defaultValue;
        }
        if (value instanceof Date) {
            return value;
        }
        if (value.toString().equals("")) {
            return this.defaultValue;
        }
        String pattern = "dd/MM/yy";
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.FRENCH);
            Date date = dateFormat.parse(value.toString());
            return date;
        }
        catch (Exception e) {
            log.warn((Object)("Unable to convert " + value + " into Date format. Pattern : " + pattern), (Throwable)e);
            return this.defaultValue;
        }
    }
}

