/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.user;

import com.cybelia.sandra.web.action.UtilAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserImpl;

public class UserForm
extends ActionForm {
    private static final long serialVersionUID = 1L;
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected String topiaId;
    protected String login;
    protected String email;
    protected boolean enabled;
    protected boolean isWeb;
    protected boolean isAdmin;
    protected boolean actif = true;
    protected String society;
    protected String profilType;
    protected List<String> profils = new ArrayList();
    protected String[] selectedProfils;

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getIsWeb() {
        return this.isWeb;
    }

    public void setIsWeb(boolean isWeb) {
        this.isWeb = isWeb;
    }

    public boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public String getSociety() {
        return this.society;
    }

    public void setSociety(String society) {
        this.society = society;
    }

    public List<String> getProfils() {
        return this.profils;
    }

    public void addProfils(String topiaId) {
        this.profils.add(topiaId);
    }

    public void setProfils(List<String> profils) {
        this.profils = profils;
    }

    public void removeProfils(String topiaId) {
        this.profils.remove(topiaId);
    }

    public String getTopiaId() {
        return this.topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getProfilType() {
        return this.profilType;
    }

    public void setProfilType(String profilType) {
        this.profilType = profilType;
    }

    public String[] getSelectedProfils() {
        return this.selectedProfils;
    }

    public void setSelectedProfils(String[] currentprofils) {
        this.selectedProfils = currentprofils;
    }

    public boolean isActif() {
        return this.actif;
    }

    public void setActif(boolean actif) {
        this.actif = actif;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"login", (String)"error.login.required");
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"email", (String)"error.email.required");
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"society", (String)"error.society.required");
        return errors;
    }

    public void fromBean(TaasUser user) {
        this.setTopiaId(user.getTopiaId());
        this.setLogin(user.getLogin());
        this.setEmail(user.getEmail());
        this.setEnabled(user.getEnabled());
        this.setSociety(user.getLink());
        this.setIsWeb(false);
        this.setIsAdmin(false);
        this.setProfilType(null);
        this.setProfils(new ArrayList());
        Collection principals = user.getPrincipals();
        for (TaasPrincipal principal : principals) {
            String name = principal.getName();
            if (name.equals(user.getLogin())) {
                Collection authorizations = principal.getAuthorizations();
                for (TaasAuthorization authorization : authorizations) {
                    String expression = authorization.getExpression();
                    int actions = authorization.getActions();
                    if ("*".equals(expression) || (actions & 1) != 1) continue;
                    this.addProfils(expression);
                }
                continue;
            }
            if (name.startsWith("com.cybelia.sandra.entities")) {
                this.setProfilType(name);
                continue;
            }
            if (name.equals("web")) {
                this.setIsWeb(true);
                continue;
            }
            if (!name.startsWith("admin-")) continue;
            this.setIsAdmin(true);
        }
    }

    public TaasUser toBean() {
        TaasUserImpl user = new TaasUserImpl();
        user.setTopiaId(this.getTopiaId());
        user.setLogin(this.getLogin());
        user.setEmail(this.getEmail());
        user.setEnabled(this.getEnabled());
        user.setLink(this.getSociety());
        return user;
    }
}

