/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.user;

import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.user.CamionSearchForm;
import com.cybelia.sandra.web.action.user.UserAction;
import com.cybelia.sandra.web.action.user.UserForm;
import com.cybelia.sandra.web.displaytag.PaginedListExtractor;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.displaytag.properties.SortOrderEnum;
import org.nuiton.topia.taas.entities.TaasUser;

public class UserAction
extends CommonMappingDispatchAction {
    public ActionForward logout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        HttpSession session = request.getSession();
        session.invalidate();
        return mapping.findForward("success");
    }

    public ActionForward admin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        return mapping.findForward("success");
    }

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        UserPaginedListExtractor extractor = new UserPaginedListExtractor(serviceWeb, null);
        PaginedListImpl list = new PaginedListImpl((PaginedListExtractor)extractor);
        list.setSortCriterion("lastConnectionDate");
        list.setSortDirection(SortOrderEnum.DESCENDING);
        request.setAttribute("users", (Object)list.fromRequest(request).acquireData(request));
        return mapping.findForward("success");
    }

    public ActionForward listCamion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        CamionSearchForm searchForm = (CamionSearchForm)form;
        UserCamionIndicateursPaginedListExtractor extractor = new UserCamionIndicateursPaginedListExtractor(serviceWeb, searchForm.getSociety(), !searchForm.isShowInactif(), null);
        PaginedListImpl list = new PaginedListImpl((PaginedListExtractor)extractor);
        list.setSortCriterion("userIndicateurs.lastSynch");
        list.setSortDirection(SortOrderEnum.DESCENDING);
        request.setAttribute("camions", (Object)list.fromRequest(request).acquireData(request));
        return mapping.findForward("success");
    }

    public ActionForward setInactifCamion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        String topiaId = request.getParameter("topiaId");
        serviceWeb.setActifCamion(null, topiaId, false);
        return mapping.findForward("success");
    }

    public ActionForward setActifCamion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        String topiaId = request.getParameter("topiaId");
        serviceWeb.setActifCamion(null, topiaId, true);
        return mapping.findForward("success");
    }

    public ActionForward sendUserActivityEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        serviceWeb.sendStatNotification();
        return mapping.findForward("success");
    }

    public ActionForward view(ActionMapping mapping, UserForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            String profilType = form.getProfilType();
            TaasUser user = serviceWeb.getSafeUser(null, topiaId);
            form.fromBean(user);
            if (StringUtils.isBlank((CharSequence)form.getProfilType())) {
                form.setProfilType(profilType);
            }
            if (StringUtils.isNotBlank((CharSequence)form.getProfilType())) {
                this.buildProfilValues(request, applicationSession, form.getProfilType(), form.getProfils());
            }
        }
        return mapping.findForward("success");
    }

    public ActionForward save(ActionMapping mapping, UserForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        TaasUser user = serviceWeb.saveUser(null, form.toBean(), form.getIsWeb(), form.getIsAdmin(), form.getProfilType());
        form.setTopiaId(user.getTopiaId());
        ApplicationSession.Cache.User.clear(applicationSession);
        ApplicationSession.Cache.UserIndicateurs.clear(applicationSession);
        return mapping.findForward("success");
    }

    public ActionForward addProfil(ActionMapping mapping, UserForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        String[] selectedProfils = form.getSelectedProfils();
        if (selectedProfils != null) {
            String topiaId = form.getTopiaId();
            for (String profil : selectedProfils) {
                serviceWeb.addProfilUser(null, topiaId, profil);
                form.addProfils(profil);
            }
        }
        return mapping.findForward("success");
    }

    public ActionForward deleteProfil(ActionMapping mapping, UserForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        String[] selectedProfils = form.getSelectedProfils();
        if (selectedProfils != null) {
            String topiaId = form.getTopiaId();
            for (String profil : selectedProfils) {
                serviceWeb.deleteProfilUser(null, topiaId, profil);
                form.removeProfils(profil);
            }
        }
        return mapping.findForward("success");
    }

    protected void buildProfilValues(HttpServletRequest request, ApplicationSession applicationSession, String profilType, List<String> profils) throws Exception {
        Map map = applicationSession.getNaming(Class.forName(profilType));
        LinkedHashMap naming = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            boolean keep = true;
            String key = (String)entry.getKey();
            Iterator<String> it = profils.iterator();
            while (keep && it.hasNext()) {
                if (!it.next().equals(key)) continue;
                keep = false;
            }
            if (!keep) continue;
            naming.put(key, entry.getValue());
        }
        request.setAttribute("profilValues", naming);
    }
}

