/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.tour;

import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.tour.CriteriaForm;
import com.cybelia.sandra.web.action.tour.ListTour;
import com.cybelia.sandra.web.action.tour.StepsHelper;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ListTourStep
extends ListTour {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        super.execute(mapping, form, request, response, applicationSession, serviceWeb);
        CriteriaForm criteria = (CriteriaForm)form;
        if (UtilAction.isNotEmptyParameter((HttpServletRequest)request, (String)"tour")) {
            String cachedToursTopiaId = request.getParameter("tour").trim();
            Tour t = serviceWeb.getTour(null, cachedToursTopiaId);
            applicationSession.setCachedToursTopiaId(cachedToursTopiaId);
            Date debut = criteria.getDateStart();
            Date fin = criteria.getDateEnd();
            String camionTopiaId = t.getCamion().getTopiaId();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Debut : " + debut + " fin : " + fin + " camionTopiaId " + camionTopiaId));
            }
            List cachedToursList = applicationSession.getCachedToursList();
            String cachedCamionTopiaId = applicationSession.getCachedCamionTopiaId();
            Date cachedDebut = applicationSession.getCachedDebut();
            Date cachedFin = applicationSession.getCachedFin();
            if (!(cachedToursList != null && cachedCamionTopiaId.equals(camionTopiaId) && cachedDebut.equals(debut) && cachedFin.equals(fin))) {
                List toursList = serviceWeb.getToursByCamionAndDates(null, camionTopiaId, debut, fin);
                applicationSession.setCachedCamionTopiaId(camionTopiaId);
                applicationSession.setCachedDebut(debut);
                applicationSession.setCachedFin(fin);
                applicationSession.setCachedToursList(toursList);
                request.setAttribute("toursNav", (Object)toursList);
            } else {
                request.setAttribute("toursNav", (Object)cachedToursList);
            }
            PaginedListImpl tours = this.getTours(request);
            request.setAttribute("steps", (Object)this.getStepsList(tours));
        }
        if (UtilAction.isEmptyParameter((HttpServletRequest)request, (String)"steps")) {
            request.setAttribute("steps", (Object)this.getStepsList(applicationSession.getListTours()));
        }
        return mapping.findForward("success");
    }

    protected List<StepsHelper.DataStep> getStepsList(PaginedListImpl<Tour> tours) {
        StepsHelper.DefaultDataSteps dataSteps = new StepsHelper.DefaultDataSteps();
        StepsHelper.getSteps((List)tours.getList(), (StepsHelper.DataSteps[])new StepsHelper.DataSteps[]{dataSteps});
        return dataSteps.getList();
    }
}

