/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ref.AbstractRefAction;
import com.cybelia.sandra.web.action.ref.ChauffeurAction;
import com.cybelia.sandra.web.action.ref.ChauffeurForm;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ChauffeurAction
extends AbstractRefAction<Chauffeur, ChauffeurForm> {
    public ChauffeurAction() {
        super(Chauffeur.class, ChauffeurPaginedListExtractor.class);
    }

    public ActionForward view(ActionMapping mapping, ChauffeurForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, ChauffeurPaginedListExtractor extractor) throws Exception {
        ActionForward forward = super.view(mapping, (ActionForm)form, request, response, serviceWeb, (AbstractRefAction.AbstractRefPaginedListExtractor)extractor);
        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            Chauffeur b = extractor.getBean(topiaId);
            Collection camions = b.getCamions();
            request.setAttribute("camions", (Object)(camions == null ? Collections.EMPTY_LIST : camions));
        }
        form.setSelectedCamions(null);
        return forward;
    }

    public ActionForward addCamions(ActionMapping mapping, ChauffeurForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, ChauffeurPaginedListExtractor extractor) throws Exception {
        String[] ids = form.getSelectedCamions();
        if (ids != null && ids.length > 0) {
            serviceWeb.addCamionsToChauffeur(null, form.getTopiaId(), ids);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("no camion selected to be added to chauffeur " + form.getTopiaId()));
        }
        request.setAttribute("code", (Object)form.getCode());
        return mapping.findForward("success");
    }

    public ActionForward deleteCamions(ActionMapping mapping, ChauffeurForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, ChauffeurPaginedListExtractor extractor) throws Exception {
        String[] ids = form.getSelectedCamions();
        if (ids != null && ids.length > 0) {
            serviceWeb.deleteCamionsToChauffeur(null, form.getTopiaId(), ids);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("no camion selected to be deleted to chauffeur " + form.getTopiaId()));
        }
        request.setAttribute("code", (Object)form.getCode());
        return mapping.findForward("success");
    }
}

