/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionImpl;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteImpl;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.TransporteurImpl;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.ref.AbstractRefForm;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class CamionForm
extends AbstractRefForm<Camion> {
    private static final long serialVersionUID = 1L;
    protected String societeId;
    protected String transporteurId;
    protected String camionPrincipalId;
    protected Camion camionPrincipal;
    protected int nombreCompartiments;

    public String getSocieteId() {
        return this.societeId;
    }

    public int getNombreCompartiments() {
        return this.nombreCompartiments;
    }

    public String getTransporteurId() {
        return this.transporteurId;
    }

    public String getCamionPrincipalId() {
        return this.camionPrincipalId;
    }

    public Camion getCamionPrincipal() {
        return this.camionPrincipal;
    }

    public void setNombreCompartiments(int nombreCompartiments) {
        this.nombreCompartiments = nombreCompartiments;
    }

    public void setSocieteId(String societeId) {
        this.societeId = societeId;
    }

    public void setTransporteurId(String transporteurId) {
        this.transporteurId = transporteurId;
    }

    public void setCamionPrincipalId(String camionPrincipalId) {
        this.camionPrincipalId = camionPrincipalId;
    }

    public void setCamionPrincipal(Camion camionPrincipal) {
        this.camionPrincipal = camionPrincipal;
        if (camionPrincipal != null) {
            this.camionPrincipalId = camionPrincipal.getTopiaId();
        }
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.camionPrincipalId = null;
        this.transporteurId = null;
        this.societeId = null;
        this.code = null;
        this.topiaId = null;
        this.nombreCompartiments = 0;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"code", (String)"error.camion.code.required");
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"societeId", (String)"error.camion.societeId.required");
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"transporteurId", (String)"error.camion.transporteurId.required");
        try {
            int nbCompartiments = UtilAction.getParameterInt((HttpServletRequest)request, (String)"nombreCompartiments");
            if (nbCompartiments <= 0) {
                errors.add("nombreCompartimentsPositif", new ActionMessage("error.camion.nombreCompartiments.syntax"));
            }
        }
        catch (UtilAction.BadInputException e) {
            errors.add("nombreCompartimentsSyntax", new ActionMessage("error.camion.nombreCompartiments.syntax"));
        }
        return errors;
    }

    public void fromBean(Camion bean) {
        this.setTopiaId(bean.getTopiaId());
        this.setCode(bean.getCode());
        this.setNombreCompartiments(bean.getNombreCompartiments());
        this.setSocieteId(bean.getSociete().getTopiaId());
        this.setTransporteurId(bean.getTransporteur().getTopiaId());
    }

    public Camion toBean() {
        CamionImpl bean = new CamionImpl();
        bean.setTopiaId(this.getTopiaId());
        bean.setCode(this.getCode());
        bean.setNombreCompartiments(this.getNombreCompartiments());
        SocieteImpl societe = new SocieteImpl();
        societe.setTopiaId(this.getSocieteId());
        bean.setSociete((Societe)societe);
        TransporteurImpl transporteur = new TransporteurImpl();
        transporteur.setTopiaId(this.getTransporteurId());
        bean.setTransporteur((Transporteur)transporteur);
        return bean;
    }
}

