/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.ref.AbstractRefAction;
import com.cybelia.sandra.web.action.ref.CamionAction;
import com.cybelia.sandra.web.action.ref.CamionForm;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CamionAction
extends AbstractRefAction<Camion, CamionForm> {
    public CamionAction() {
        super(Camion.class, CamionPaginedListExtractor.class);
    }

    public ActionForward view(ActionMapping mapping, CamionForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, CamionPaginedListExtractor extractor) throws Exception {
        ActionForward forward = super.view(mapping, (ActionForm)form, request, response, serviceWeb, (AbstractRefAction.AbstractRefPaginedListExtractor)extractor);
        String id = form.getTopiaId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            Camion camionPrincipal = serviceWeb.getCamionPrincipal(null, id);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("obtain camion principal for [" + id + "] : " + (camionPrincipal == null ? null : camionPrincipal.getCode())));
            }
            form.setCamionPrincipal(camionPrincipal);
        }
        return forward;
    }

    public ActionForward save(ActionMapping mapping, CamionForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, CamionPaginedListExtractor extractor) throws Exception {
        ActionForward forward = super.save(mapping, (ActionForm)form, request, response, serviceWeb, (AbstractRefAction.AbstractRefPaginedListExtractor)extractor);
        String camionPrincipalId = form.getCamionPrincipalId();
        if (StringUtils.isNotBlank((CharSequence)camionPrincipalId)) {
            String camionId = form.getTopiaId();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("camion " + camionId + " has a principal camion " + camionPrincipalId));
            }
            serviceWeb.addCamionToCamionPrincipal(null, camionId, camionPrincipalId);
            ApplicationSession.Cache.Camion.clear(ApplicationSession.get((HttpServletRequest)request));
        }
        return forward;
    }

    protected PaginedListImpl<Camion> getPaginedList(String name, HttpServletRequest request, AbstractRefAction.AbstractRefPaginedListExtractor<Camion> extractor) {
        PaginedListImpl paginedList = super.getPaginedList(name, request, extractor);
        paginedList.setSortCriterion("code");
        return paginedList;
    }
}

