/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.action.ref.AbstractRefAction;
import com.cybelia.sandra.web.action.ref.AbstractRefForm;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AbstractRefAction<B extends TopiaEntity, F extends AbstractRefForm<B>>
extends CommonMappingDispatchAction {
    protected final Class<B> beanClass;
    protected Constructor<? extends AbstractRefPaginedListExtractor<B>> extractorConstructor;

    protected AbstractRefAction(Class<B> beanClass, Class<? extends AbstractRefPaginedListExtractor<B>> extractorClass) {
        this.beanClass = beanClass;
        try {
            this.extractorConstructor = extractorClass.getConstructor(ServiceWeb.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Object[] getArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceWeb serviceWeb = ServiceFactory.newServiceWeb();
        try {
            return new Object[]{mapping, form, request, response, serviceWeb, this.extractorConstructor.newInstance(serviceWeb)};
        }
        catch (Exception e) {
            throw new RuntimeException("could not instanciate extractor " + this.extractorConstructor + " for reason " + e.getMessage(), e);
        }
    }

    protected PaginedListImpl<B> getPaginedList(String name, HttpServletRequest request, AbstractRefPaginedListExtractor<B> extractor) {
        PaginedListImpl list = new PaginedListImpl(extractor);
        request.setAttribute(name, (Object)list);
        return list;
    }

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, AbstractRefPaginedListExtractor<B> extractor) throws Exception {
        PaginedListImpl paginedList = this.getPaginedList("beans", request, extractor);
        List beans = paginedList.fromRequest(request).acquireData(request).getList();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("retreave list from service " + (beans == null ? 0 : beans.size())));
        }
        return mapping.findForward("success");
    }

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, AbstractRefPaginedListExtractor<B> extractor) throws Exception {
        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            TopiaEntity camion = (TopiaEntity)extractor.getBean(topiaId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("retreave bean from service : " + camion));
            }
            this.getForm(form).fromBean(camion);
        }
        return mapping.findForward("success");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, AbstractRefPaginedListExtractor<B> extractor) throws Exception {
        TopiaEntity bean = this.getForm(form).toBean();
        bean = (TopiaEntity)extractor.saveBean((Object)bean);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("saved " + bean));
        }
        ApplicationSession.get((HttpServletRequest)request).clearNaming(this.beanClass);
        return mapping.findForward("success");
    }

    protected F getForm(ActionForm form) {
        return (F)((AbstractRefForm)form);
    }
}

