/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.notifier;

import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.security.SecurityHelper;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.UtilAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.entities.TaasUser;

public class RecipientForm
extends ActionForm {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected String topiaId;
    protected String eventTopiaId;
    protected String label;
    protected String[] selected;
    protected transient List<String> frees;
    protected transient List<String> users;
    protected transient List<String> profils;
    protected transient List<String> availableUsers = new ArrayList();
    protected String profilType;
    protected boolean isAdmin;
    protected transient List<String> availableProfils = new ArrayList();
    private static final long serialVersionUID = 1L;

    public List<String> getAvailableUsers() {
        return this.availableUsers;
    }

    public void setAvailableUsers(List<String> availableUsers) {
        this.availableUsers = availableUsers;
    }

    public List<String> getAvailableProfils() {
        return this.availableProfils;
    }

    public void setAvailableProfils(List<String> availableProfils) {
        this.availableProfils = availableProfils;
    }

    public List<String> getFrees() {
        return this.frees;
    }

    public void setFrees(List<String> frees) {
        this.frees = frees;
    }

    public List<String> getProfils() {
        return this.profils;
    }

    public void setProfils(List<String> profils) {
        this.profils = profils;
    }

    public String[] getSelected() {
        return this.selected;
    }

    public void setSelected(String[] selected) {
        this.selected = selected;
    }

    public String getTopiaId() {
        return this.topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public String getEventTopiaId() {
        return this.eventTopiaId;
    }

    public void setEventTopiaId(String eventTopiaId) {
        this.eventTopiaId = eventTopiaId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getProfilType() {
        return this.profilType;
    }

    public void setProfilType(String profilType) {
        this.profilType = profilType;
    }

    public boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"topiaId", (String)"error.service.notifier.unfound");
        return errors;
    }

    public void fromBean(Cron cron, ApplicationSession applicationSession) throws Exception {
        this.setTopiaId(cron.getTopiaId());
        this.setEventTopiaId(cron.getEvent().getTopiaId());
        this.setLabel(cron.getLabel());
        this.users = new ArrayList();
        this.profils = new ArrayList();
        this.frees = new ArrayList();
        for (String string : cron.getRecipients()) {
            String topiaId = SecurityHelper.getTopiaIdRecipient((String)string);
            if (TopiaId.isValidId((String)topiaId)) {
                if (TopiaId.getClassName((String)topiaId).isAssignableFrom(TaasUser.class)) {
                    this.users.add(string);
                    continue;
                }
                this.profils.add(string);
                continue;
            }
            this.frees.add(string);
        }
        this.availableUsers.clear();
        for (Map.Entry entry : applicationSession.getNamingUsers().entrySet()) {
            boolean free = true;
            String key = (String)entry.getKey();
            Iterator it = this.users.iterator();
            while (free && it.hasNext()) {
                free = !((String)it.next()).equals(key);
            }
            if (!free) continue;
            this.availableUsers.add(key);
        }
        this.availableProfils.clear();
        if (this.profilType != null && !"".equals(this.profilType)) {
            Map map = applicationSession.getNaming(Class.forName(this.profilType));
            for (Map.Entry entry : map.entrySet()) {
                boolean free = true;
                String key = (String)entry.getKey();
                Iterator it = this.profils.iterator();
                while (free && it.hasNext()) {
                    String element = (String)it.next();
                    free = !element.equals(key) && !element.equals(SecurityHelper.getAdminProfilRecipient((String)key));
                }
                if (!free) continue;
                this.availableProfils.add(key);
            }
        }
        this.selected = null;
    }
}

