/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.notifier;

import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.services.ServiceNotifier;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.action.notifier.CronAction;
import com.cybelia.sandra.web.action.notifier.CronForm;
import com.cybelia.sandra.web.displaytag.PaginedListExtractor;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CronAction
extends CommonMappingDispatchAction {
    protected Object[] getArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, ApplicationSession.get((HttpServletRequest)request), ServiceFactory.newServiceNotifier()};
    }

    public ActionForward list(ActionMapping mapping, CronForm form, HttpServletRequest request, ApplicationSession applicationSession, ServiceNotifier serviceNotifier) throws Exception {
        CronPaginedListExtractor extractor = new CronPaginedListExtractor(serviceNotifier);
        PaginedListImpl list = new PaginedListImpl((PaginedListExtractor)extractor);
        list.setSortCriterion("label");
        request.setAttribute("beans", (Object)list.fromRequest(request).acquireData(request));
        return mapping.findForward("success");
    }

    public ActionForward selectEvent(ActionMapping mapping, CronForm form, HttpServletRequest request, ApplicationSession applicationSession, ServiceNotifier serviceNotifier) throws Exception {
        String eventTopiaId = request.getParameter("eventTopiaId");
        if (StringUtils.isNotBlank((CharSequence)eventTopiaId)) {
            Event event = serviceNotifier.getEvent(null, eventTopiaId);
            form.setVariables(event.getVariables());
            form.setEventTopiaId(event.getTopiaId());
            String name = event.getType();
            form.setTemplateModel(name);
            form.setTemplateName(name);
            String content = serviceNotifier.getTemplate(name);
            form.setTemplateContent(content);
        }
        return mapping.findForward("success");
    }

    public ActionForward selectAuthor(ActionMapping mapping, CronForm form, HttpServletRequest request, ApplicationSession applicationSession, ServiceNotifier serviceNotifier) throws Exception {
        String authorTopiaId = request.getParameter("authorTopiaId");
        if (StringUtils.isNotBlank((CharSequence)authorTopiaId)) {
            form.setAuthorTopiaId(authorTopiaId);
        }
        return mapping.findForward("success");
    }

    public ActionForward selectTemplate(ActionMapping mapping, CronForm form, HttpServletRequest request, ApplicationSession applicationSession, ServiceNotifier serviceNotifier) throws Exception {
        String eventTopiaId = request.getParameter("eventTopiaId");
        if (StringUtils.isNotBlank((CharSequence)eventTopiaId)) {
            Event event = serviceNotifier.getEvent(null, eventTopiaId);
            form.setVariables(event.getVariables());
            form.setEventTopiaId(event.getTopiaId());
        }
        String name = form.getTemplateModel();
        form.setTemplateName(name);
        String content = "";
        if (StringUtils.isNotBlank((CharSequence)name)) {
            content = serviceNotifier.getTemplate(name);
        }
        form.setTemplateContent(content);
        return mapping.findForward("success");
    }

    public ActionForward view(ActionMapping mapping, CronForm form, HttpServletRequest request, ApplicationSession applicationSession, ServiceNotifier serviceNotifier) throws Exception {
        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            Cron cron = serviceNotifier.getCron(null, topiaId);
            String template = serviceNotifier.getTemplate(cron.getTemplate());
            form.fromBean(cron, template);
        }
        applicationSession.setTemplates(serviceNotifier.getTemplates());
        return mapping.findForward("success");
    }

    public ActionForward save(ActionMapping mapping, CronForm form, HttpServletRequest request, ApplicationSession applicationSession, ServiceNotifier serviceNotifier) throws Exception {
        String content = form.getTemplateContent();
        String name = form.getTemplateName();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = form.getTemplateModel();
        }
        serviceNotifier.saveTemplate(name, content);
        Cron cron = form.toBean();
        cron = serviceNotifier.saveCron(null, cron);
        form.fromBean(cron, content);
        applicationSession.setTemplates(serviceNotifier.getTemplates());
        return mapping.findForward("success");
    }

    public ActionForward delete(ActionMapping mapping, CronForm form, HttpServletRequest request, ApplicationSession applicationSession, ServiceNotifier serviceNotifier) throws Exception {
        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            serviceNotifier.deleteCron(null, topiaId);
        }
        return mapping.findForward("success");
    }
}

