/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.loading.model;

import com.cybelia.sandra.web.action.loading.model.Column;
import com.cybelia.sandra.web.action.loading.model.Day;
import java.util.Calendar;
import java.util.Date;

public class ModelHelper {
    public static final int ONE_MINUTE_IN_MILLI = 60000;
    public static final int ONE_HOUR_IN_MIN = 60;

    public static Date getStartingDateFromCurrentDate(Date currentDate, int nbHours, int positionCurrentDate) {
        if (currentDate == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        double minutes = nbHours * 60 * positionCurrentDate / 100;
        calendar.add(12, (int)(-minutes));
        calendar.set(12, 0);
        return calendar.getTime();
    }

    public static Column[] createColumnModel(int nbHours, Day[] days, Date currentDate) {
        Column[] result = new Column[nbHours];
        int columnIndex = 0;
        for (Day day : days) {
            int max = day.getLastHour();
            for (int hour = day.getFirstHour(); hour <= max; ++hour) {
                Column column = new Column();
                column.setDay(day);
                column.setHour(hour);
                column.setFirstHour(hour == day.getFirstHour());
                result[columnIndex++] = column;
                if (currentDate == null || !column.getStartingDate().before(currentDate) || !column.getEndingDate().after(currentDate)) continue;
                column.setCurrentDate(currentDate);
            }
        }
        return result;
    }
}

