/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.loading.model;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.StatutEnum;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.web.action.loading.model.Chargement;
import com.cybelia.sandra.web.action.loading.model.Column;
import com.cybelia.sandra.web.action.loading.model.Day;
import com.cybelia.sandra.web.action.loading.model.ModelHelper;
import com.cybelia.sandra.web.action.tour.StepsHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadingTable
extends StepsHelper.DataSteps {
    private static final long serialVersionUID = 1L;
    protected Log log = LogFactory.getLog(this.getClass());
    protected static float QUANTITY_TIME_UNIT = 10000.0f;
    protected Date startingDate;
    protected Date endingDate;
    protected Date currentDate;
    protected int currentDateNbPixelForMinute;
    protected int nbPixelPerHour;
    protected Map<String, Column[]> rows;
    protected Column[] hours;
    protected ChargementUsineConfig config;
    protected Day[] days;
    protected Chargement chargement;
    protected Camion camion;
    public static int ETAPE_STATUS_TERMINED = -1;
    public static int ETAPE_STATUS_CHARGED = 40;
    public static int TOUR_STATUS_TERMINED = -1;
    public static int TOUR_STATUS_DELIVERY = 4;

    public LoadingTable(Date currentDate) {
        this.currentDate = currentDate;
    }

    public void init(Date startingDate, Date endingDate, ChargementUsineConfig config) {
        this.startingDate = startingDate;
        this.endingDate = endingDate;
        this.nbPixelPerHour = (int)(900.0f / (float)config.getNombreHeures());
        this.config = config;
        if (this.currentDate.before(startingDate) || this.currentDate.after(endingDate)) {
            this.currentDate = null;
            this.currentDateNbPixelForMinute = 0;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.currentDate);
            this.currentDateNbPixelForMinute = this.nbPixelPerHour * calendar.get(12) / 60;
        }
    }

    public void initRows() {
        this.days = Day.newDays((Date)this.startingDate, (Date)this.endingDate);
        this.hours = ModelHelper.createColumnModel((int)this.config.getNombreHeures(), (Day[])this.days, (Date)this.currentDate);
        this.rows = new LinkedHashMap();
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public Date getEndingDate() {
        return this.endingDate;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public int getNbPixelPerHour() {
        return this.nbPixelPerHour;
    }

    public Day[] getDays() {
        return this.days;
    }

    public Map<String, Column[]> getRows() {
        return this.rows;
    }

    public Column[] getHours() {
        return this.hours;
    }

    public int getCurrentDateNbPixelForMinute() {
        return this.currentDateNbPixelForMinute;
    }

    protected void addDataStep(Etape step) {
        if (this.chargement != null) {
            boolean oneAvailable = false;
            boolean allAvailable = true;
            boolean oneCharged = false;
            this.chargement.setDelay(this.chargement.getDelay() + this.config.getTempFixeParLigneProduit());
            for (LigneProduit produit : step.getProduits()) {
                Date date;
                Float delay = Float.valueOf((float)produit.getQuantiteACharger() / QUANTITY_TIME_UNIT);
                delay = Float.valueOf(delay.floatValue() * (float)this.config.getTempVariableParQuantite());
                this.chargement.setDelay(this.chargement.getDelay() + delay.intValue());
                InfoChargement info = produit.getInfoChargement();
                if (step.getEtat() > ETAPE_STATUS_CHARGED && (date = info.getDate()) != null) {
                    this.chargement.setStartingDate(date);
                }
                oneAvailable |= produit.getDisponible();
                allAvailable &= produit.getDisponible();
                oneCharged |= produit.getInfoChargement().getQuantite() > 0;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.chargement.getStartingDate());
            this.chargement.setNbPixelForMinute(this.nbPixelPerHour * calendar.get(12) / 60);
            this.addChargement(this.camion.getTopiaId(), this.chargement);
            if (oneCharged) {
                this.setStatutChargement(this.chargement, StatutEnum.CHARGE);
            } else if (allAvailable) {
                this.setStatutChargement(this.chargement, StatutEnum.DISPONIBLE);
            } else if (oneAvailable) {
                this.setStatutChargement(this.chargement, StatutEnum.SEMI_DISPONIBLE);
            }
        }
    }

    protected void addDataStep(Usine factory) {
        if (factory.getTopiaId().equals(this.config.getUsine().getTopiaId())) {
            this.camion = this.tour.getCamion();
            this.chargement = new Chargement();
            this.chargement.setCamionId(this.camion.getTopiaId());
            this.chargement.setTourId(this.tour.getTopiaId());
            this.chargement.setTourNumero(this.tour.getNumero());
            this.chargement.setStartingDate(this.tour.getDateChargement());
            this.chargement.setStatut(StatutEnum.PLANIFIE);
            this.chargement.setDelay(this.config.getTempFixeParTournee());
        } else {
            this.chargement = null;
        }
    }

    protected void addDataStep(SuiviEtape step) {
        this.addDataStep(step.getEtape());
        if (this.chargement != null && step.getStatus() == ETAPE_STATUS_TERMINED) {
            this.setStatutChargement(this.chargement, StatutEnum.SEMI_LIVRE);
        }
    }

    protected void addDataStep(SuiviUsine factory) {
        this.addDataStep(factory.getUsine());
        if (this.chargement != null) {
            Date date = factory.getDateChargementPrevue();
            if (date != null && date.getTime() != 0L) {
                this.chargement.setStartingDate(date);
            }
            if (this.tour.getSuiviTour().getStatus() == TOUR_STATUS_DELIVERY) {
                this.setStatutChargement(this.chargement, StatutEnum.EN_COURS_LIVRAISON);
            }
            if (this.tour.getSuiviTour().getStatus() == TOUR_STATUS_TERMINED) {
                this.setStatutChargement(this.chargement, StatutEnum.TERMINE);
            }
        }
    }

    protected void setStatutChargement(Chargement chargement, StatutEnum statut) {
        if (chargement.getStatut().getCode() < statut.getCode()) {
            chargement.setStatut(statut);
        }
    }

    protected void addChargement(String camionId, Chargement chargement) {
        Column[] columns = (Column[])this.rows.get(camionId);
        if (columns == null) {
            columns = ModelHelper.createColumnModel((int)this.config.getNombreHeures(), (Day[])this.days, null);
            this.rows.put(this.camion.getTopiaId(), columns);
        }
        for (Column column : columns) {
            Date sDate = column.getStartingDate();
            Date eDate = column.getEndingDate();
            Date date = chargement.getStartingDate();
            if (!sDate.equals(date) && !sDate.before(date) || !eDate.after(date)) continue;
            column.setChargement(chargement);
            return;
        }
    }
}

