/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.loading;

import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.StatutEnum;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.loading.model.LoadingTable;
import com.cybelia.sandra.web.action.loading.model.ModelHelper;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class ChargementUsineForm
extends ActionForm {
    protected String usineTopiaId = ApplicationSession.Cache.Usine.getDefaultEntry();
    protected transient ChargementUsineConfig config;
    protected transient LoadingTable model;
    protected Long startingDateAsLong;
    protected long previousStartingDateAsLong;
    protected long previousEndingDateAsLong;
    protected long nextStartingDateAsLong;
    protected long nextEndingDateAsLong;
    private static final long serialVersionUID = 1L;

    public void setUsineTopiaId(String usineTopiaId) {
        this.usineTopiaId = usineTopiaId;
    }

    public void setStartingDateAsLong(long startingDateAsLong) {
        this.startingDateAsLong = startingDateAsLong;
    }

    public StatutEnum[] getStatus() {
        return StatutEnum.values();
    }

    public String getUsineTopiaId() {
        return this.usineTopiaId;
    }

    public long getStartingDateAsLong() {
        return this.startingDateAsLong;
    }

    public long getPreviousStartingDateAsLong() {
        return this.previousStartingDateAsLong;
    }

    public long getNextStartingDateAsLong() {
        return this.nextStartingDateAsLong;
    }

    public Date getPreviousStartingDate() {
        return new Date(this.previousStartingDateAsLong);
    }

    public Date getPreviousEndingDate() {
        return new Date(this.previousEndingDateAsLong);
    }

    public Date getNextStartingDate() {
        return new Date(this.nextStartingDateAsLong);
    }

    public Date getNextEndingDate() {
        return new Date(this.nextEndingDateAsLong);
    }

    public ChargementUsineConfig getConfig() {
        return this.config;
    }

    public LoadingTable getModel() {
        return this.model;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"usineTopiaId", (String)"error.loading.usine.required");
        return errors;
    }

    public void fromBean(ChargementUsineConfig bean, LoadingTable model) throws Exception {
        Date startingDate;
        if (bean != null) {
            this.config = bean;
            this.setUsineTopiaId(bean.getUsine().getTopiaId());
        }
        this.model = model;
        Date currentDate = model.getCurrentDate();
        if (this.startingDateAsLong == null || this.startingDateAsLong == 0L) {
            startingDate = ModelHelper.getStartingDateFromCurrentDate((Date)currentDate, (int)this.config.getNombreHeures(), (int)this.config.getPositionHeureActuelle());
            this.startingDateAsLong = startingDate.getTime();
        } else {
            startingDate = new Date(this.startingDateAsLong);
        }
        int amount = this.config.getNombreHeures();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startingDate);
        calendar.add(11, amount - 1);
        Date endingDate = calendar.getTime();
        this.nextStartingDateAsLong = endingDate.getTime();
        calendar.setTime(endingDate);
        calendar.add(11, amount - 1);
        this.nextEndingDateAsLong = calendar.getTime().getTime();
        calendar.setTime(startingDate);
        calendar.add(11, -amount + 1);
        this.previousStartingDateAsLong = calendar.getTime().getTime();
        model.init(startingDate, endingDate, this.config);
    }
}

