/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.loading;

import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.StatutEnum;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.loading.ChargementUsineForm;
import com.cybelia.sandra.web.action.loading.model.LoadingTable;
import com.cybelia.sandra.web.action.tour.StepsHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;

public class ChargementUsineAction
extends CommonMappingDispatchAction {
    public ActionForward view(ActionMapping mapping, ChargementUsineForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        String topiaId = form.getUsineTopiaId();
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            ChargementUsineConfig config = serviceWeb.getChargementUsineConfigForUsine(null, topiaId);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (UtilAction.isNotEmptyParameter((HttpServletRequest)request, (String)"year")) {
                int year = UtilAction.getParameterInt((HttpServletRequest)request, (String)"year");
                int month = UtilAction.getParameterInt((HttpServletRequest)request, (String)"month");
                int date = UtilAction.getParameterInt((HttpServletRequest)request, (String)"date");
                int hour = UtilAction.getParameterInt((HttpServletRequest)request, (String)"hour");
                int minute = UtilAction.getParameterInt((HttpServletRequest)request, (String)"minute");
                calendar.set(year, month, date, hour, minute);
            }
            Date currentDate = calendar.getTime();
            LoadingTable model = new LoadingTable(currentDate);
            form.fromBean(config, model);
            this.buildModel(form, serviceWeb);
        }
        return mapping.findForward("success");
    }

    public ActionForward drawCellule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {
        response.setContentType("image/jpeg");
        int statutStr = UtilAction.getParameterInt((HttpServletRequest)request, (String)"statut");
        StatutEnum statut = StatutEnum.valueOfFromCode((int)statutStr);
        int numero = UtilAction.getParameterInt((HttpServletRequest)request, (String)"numero");
        long startingDate = UtilAction.getParameterLong((HttpServletRequest)request, (String)"startingDate");
        int delay = UtilAction.getParameterInt((HttpServletRequest)request, (String)"delay");
        int nbHours = UtilAction.getParameterInt((HttpServletRequest)request, (String)"nbHours");
        BufferedImage image = this.buildImage(statut, numero, new Date(startingDate), nbHours, delay, 30);
        ImageIO.write((RenderedImage)image, "gif", (OutputStream)response.getOutputStream());
        return null;
    }

    protected void buildModel(ChargementUsineForm form, ServiceWeb serviceWeb) throws LogicException, TopiaException {
        LoadingTable model = form.getModel();
        List tours = serviceWeb.getLoading(null, model.getStartingDate(), model.getEndingDate(), form.getUsineTopiaId());
        model.initRows();
        StepsHelper.getSteps((List)tours, (StepsHelper.DataSteps[])new StepsHelper.DataSteps[]{model});
    }

    protected BufferedImage buildImage(StatutEnum statut, int numero, Date startingDate, int nbHours, int delay, int height) throws Exception {
        int size = 15 * delay / nbHours;
        BufferedImage image = new BufferedImage(size, height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setPaint(statut.getColor());
        g2.fillRect(0, 0, size, height);
        g2.setPaint(Color.WHITE);
        g2.drawString(numero + "", 1, 2 * height / 3);
        g2.setPaint(Color.BLACK);
        g2.drawRect(0, 0, size - 1, height - 1);
        return image;
    }
}

