/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.breeder.InfoAccessForm;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.taas.entities.TaasUser;

public class InfoAccessAction
extends CommonMappingDispatchAction {
    protected String cachedEleveurTopiaId = null;
    protected Eleveur cachedEleveur = null;

    protected Object[] getArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, response, ServiceFactory.newServiceWeb()};
    }

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb) throws Exception {
        this.log.info((Object)("InfoAccessAction list whith topiaId : " + request.getAttribute("breederTopiaId")));
        String topiaId = (String)request.getAttribute("breederTopiaId");
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            this.cachedEleveurTopiaId = topiaId;
            this.cachedEleveur = serviceWeb.getEleveur(null, topiaId);
            ArrayList<InfoAccess> infoAccess = new ArrayList<InfoAccess>();
            for (InfoAccess silo : this.cachedEleveur.getActiveAccesSilo()) {
                if (silo == null) continue;
                infoAccess.add(silo);
            }
            request.setAttribute("accesSilos", infoAccess);
        }
        return mapping.findForward("success");
    }

    public ActionForward view(ActionMapping mapping, InfoAccessForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb) throws Exception {
        if (UtilAction.isNotEmptyParameter((HttpServletRequest)request, (String)"breederTopiaId")) {
            String breederTopiaId = UtilAction.getParameterString((HttpServletRequest)request, (String)"breederTopiaId");
            form.setEleveurTopiaId(breederTopiaId);
            this.cachedEleveurTopiaId = breederTopiaId;
        }
        if (UtilAction.isNotEmptyParameter((HttpServletRequest)request, (String)"topiaId")) {
            String topiaId = UtilAction.getParameterString((HttpServletRequest)request, (String)"topiaId");
            InfoAccess infoAccess = serviceWeb.getInfoAccess(null, topiaId);
            if (infoAccess == null) {
                this.log.error((Object)("Cant display infoAccess : " + topiaId));
            } else {
                form.fromBean(infoAccess);
            }
        }
        this.chargeEleveur(request, form, serviceWeb);
        return mapping.findForward("success");
    }

    public ActionForward delete(ActionMapping mapping, InfoAccessForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb) throws Exception {
        String topiaId = UtilAction.getParameterString((HttpServletRequest)request, (String)"topiaId");
        serviceWeb.deleteAccesSilo(null, topiaId);
        this.chargeEleveur(request, form, serviceWeb);
        return mapping.findForward("success");
    }

    public ActionForward lockInfoAccess(ActionMapping mapping, InfoAccessForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb) throws Exception {
        String topiaId = form.getTopiaId();
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            serviceWeb.lockOrUnlockInfoAccess(null, topiaId);
        }
        return this.view(mapping, form, request, response, serviceWeb);
    }

    public ActionForward unlockInfoAccess(ActionMapping mapping, InfoAccessForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb) throws Exception {
        String topiaId = UtilAction.getParameterString((HttpServletRequest)request, (String)"topiaId");
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            serviceWeb.lockOrUnlockInfoAccess(null, topiaId);
        }
        this.chargeEleveur(request, form, serviceWeb);
        return mapping.findForward("success");
    }

    public ActionForward requestToUnlock(ActionMapping mapping, InfoAccessForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb) throws Exception {
        String topiaId = UtilAction.getParameterString((HttpServletRequest)request, (String)"infoaccess");
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            TaasUser user = ServiceFactory.newServiceWeb().getUser();
            Eleveur eleveur = this.getEleveur(request, form, serviceWeb);
            ServiceFactory.newServiceNotifier().notifyEvent("requestUnlockInfoAccess", new String[]{ServiceHelper.getSandraUrl(), user.getLogin(), eleveur.getTopiaId(), topiaId});
        }
        return mapping.findForward("success");
    }

    public ActionForward save(ActionMapping mapping, InfoAccessForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb) throws Exception {
        serviceWeb.saveInfoAccess(null, form.toBean(), this.cachedEleveurTopiaId);
        this.chargeEleveur(request, form, serviceWeb);
        return mapping.findForward("success");
    }

    protected void chargeEleveur(HttpServletRequest request, InfoAccessForm form, ServiceWeb serviceWeb) {
        try {
            Eleveur eleveur = this.getEleveur(request, form, serviceWeb);
            request.setAttribute("topiaId", (Object)eleveur.getTopiaId());
            request.setAttribute("breeder", (Object)eleveur);
        }
        catch (Exception ex) {
            this.log.error((Object)"Cant create breeder form ", (Throwable)ex);
        }
    }

    protected Eleveur getEleveur(HttpServletRequest request, InfoAccessForm form, ServiceWeb serviceWeb) {
        if (this.cachedEleveur == null) {
            try {
                if (this.cachedEleveurTopiaId == null && form != null && form.getEleveurTopiaId() != null && !form.getEleveurTopiaId().trim().isEmpty()) {
                    this.cachedEleveurTopiaId = form.getEleveurTopiaId();
                    this.log.info((Object)("form.getEleveurTopiaId() != null " + this.cachedEleveurTopiaId));
                }
                if (this.cachedEleveurTopiaId == null) {
                    String infoAccessTopiaId = UtilAction.getParameterString((HttpServletRequest)request, (String)"topiaId");
                    this.cachedEleveur = serviceWeb.findEleveurByAccesSilo(null, infoAccessTopiaId);
                    this.cachedEleveurTopiaId = this.cachedEleveur.getTopiaId();
                } else {
                    this.cachedEleveur = serviceWeb.getEleveur(null, this.cachedEleveurTopiaId);
                }
            }
            catch (UtilAction.BadInputException ex) {
                this.log.info((Object)"Eleveur not found : ", (Throwable)ex);
            }
            catch (TopiaException ex) {
                this.log.info((Object)"Eleveur not found : ", (Throwable)ex);
            }
            catch (LogicException ex) {
                this.log.info((Object)"Eleveur not found : ", (Throwable)ex);
            }
        }
        return this.cachedEleveur;
    }
}

