/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurImpl;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessImpl;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteImpl;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.PointGPSImpl;
import com.cybelia.sandra.entities.sig.TraceGPS;
import com.cybelia.sandra.web.action.UtilAction;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class BreederForm
extends ActionForm {
    private static final long serialVersionUID = 1L;
    protected String topiaId;
    protected String society;
    protected String societyName;
    protected String code;
    protected String telephone;
    protected String mobile;
    protected String raisonSociale;
    protected String adresse;
    protected String codePostal;
    protected String ville;
    protected int niveauSecurite;
    protected String email;
    protected String codeINSEE;
    protected String commentaire;
    protected String contrainteHoraire;
    protected boolean tomTomGPSLocked;
    protected double latitude = 0.0;
    protected double longitude = 0.0;
    protected transient List<Note> notes;
    protected transient Collection<InfoAccess> accesSilos;
    protected transient InfoAccess accesEleveur;
    protected String accesTopiaId;
    protected String accesSilo;
    protected String modeChargement;
    protected String nomAccess;
    protected int type;
    protected int accessNiveauSecurite;
    protected String commentSecurite;
    protected String[] risques;
    protected int etat;
    protected PointGPS gps;
    protected TraceGPS traceGPS;
    protected boolean existingGPS;
    protected String eleveurTopiaId;

    public String getTopiaId() {
        return this.topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getAccesSilo() {
        return this.accesSilo;
    }

    public void setAccesSilo(String accesSilo) {
        this.accesSilo = accesSilo;
    }

    public String getAccesTopiaId() {
        return this.accesTopiaId;
    }

    public void setAccesTopiaId(String accesTopiaId) {
        this.accesTopiaId = accesTopiaId;
    }

    public int getAccessNiveauSecurite() {
        return this.accessNiveauSecurite;
    }

    public void setAccessNiveauSecurite(int accessNiveauSecurite) {
        this.accessNiveauSecurite = accessNiveauSecurite;
    }

    public String getCommentSecurite() {
        return this.commentSecurite;
    }

    public void setCommentSecurite(String commentSecurite) {
        this.commentSecurite = commentSecurite;
    }

    public String getEleveurTopiaId() {
        return this.eleveurTopiaId;
    }

    public void setEleveurTopiaId(String eleveurTopiaId) {
        this.eleveurTopiaId = eleveurTopiaId;
    }

    public int getEtat() {
        return this.etat;
    }

    public void setEtat(int etat) {
        this.etat = etat;
    }

    public boolean isExistingGPS() {
        return this.existingGPS;
    }

    public void setExistingGPS(boolean existingGPS) {
        this.existingGPS = existingGPS;
    }

    public PointGPS getGps() {
        return this.gps;
    }

    public void setGps(PointGPS gps) {
        this.gps = gps;
    }

    public String getModeChargement() {
        return this.modeChargement;
    }

    public void setModeChargement(String modeChargement) {
        this.modeChargement = modeChargement;
    }

    public String getNomAccess() {
        return this.nomAccess;
    }

    public void setNomAccess(String nomAccess) {
        this.nomAccess = nomAccess;
    }

    public String[] getRisques() {
        return this.risques;
    }

    public void setRisques(String[] risques) {
        this.risques = risques;
    }

    public TraceGPS getTraceGPS() {
        return this.traceGPS;
    }

    public void setTraceGPS(TraceGPS traceGPS) {
        this.traceGPS = traceGPS;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getAdresse() {
        return this.adresse;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public String getCodePostal() {
        return this.codePostal;
    }

    public void setCodePostal(String codePostal) {
        this.codePostal = codePostal;
    }

    public String getRaisonSociale() {
        return this.raisonSociale;
    }

    public void setRaisonSociale(String raisonSociale) {
        this.raisonSociale = raisonSociale;
    }

    public String getVille() {
        return this.ville;
    }

    public void setVille(String ville) {
        this.ville = ville;
    }

    public String getCodeINSEE() {
        return this.codeINSEE;
    }

    public void setCodeINSEE(String codeINSEE) {
        this.codeINSEE = codeINSEE;
    }

    public String getCommentaire() {
        return this.commentaire;
    }

    public void setCommentaire(String commentaire) {
        this.commentaire = commentaire;
    }

    public String getContrainteHoraire() {
        return this.contrainteHoraire;
    }

    public void setContrainteHoraire(String contrainteHoraire) {
        this.contrainteHoraire = contrainteHoraire;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public int getNiveauSecurite() {
        return this.niveauSecurite;
    }

    public void setNiveauSecurite(int niveauSecurite) {
        this.niveauSecurite = niveauSecurite;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSociety() {
        return this.society;
    }

    public void setSociety(String society) {
        this.society = society;
    }

    public Collection<Note> getNotes() {
        if (this.notes != null) {
            Collections.sort(this.notes, new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.notes;
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public int getNoteSize() {
        return this.notes == null ? 0 : this.notes.size();
    }

    public boolean isHasTomTomGPS() {
        return this.getLatitude() != 0.0 || this.getLongitude() != 0.0;
    }

    public boolean isTomTomGPSLocked() {
        return this.tomTomGPSLocked;
    }

    public void setTomTomGPSLocked(boolean tomTomGPSLocked) {
        this.tomTomGPSLocked = tomTomGPSLocked;
    }

    public String getSocietyName() {
        return this.societyName;
    }

    public void setSocietyName(String societyName) {
        this.societyName = societyName;
    }

    public InfoAccess getAccesEleveur() {
        return this.accesEleveur;
    }

    public void setAccesEleveur(InfoAccess accesEleveur) {
        this.accesEleveur = accesEleveur;
    }

    public Collection<InfoAccess> getAccesSilos() {
        return this.accesSilos;
    }

    public void setAccesSilos(Collection<InfoAccess> accesSilos) {
        this.accesSilos = accesSilos;
    }

    protected List<String> getListRisques() {
        ArrayList<String> result = new ArrayList<String>();
        String[] risks = this.getRisques();
        if (risks != null) {
            for (String s : risks) {
                result.add(s);
            }
        }
        return result;
    }

    public String getTitle() {
        return SandraHelper.getEleveurTitle((String)this.getRaisonSociale(), (String)this.getSocietyName(), (String)this.getCode(), (String)this.getVille(), (String)this.getCodePostal());
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"topiaId", (String)"error.breeder.required");
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"latitude", (String)"error.breeder.latitude.required");
        UtilAction.checkRequiredField((HttpServletRequest)request, (ActionErrors)errors, (String)"longitude", (String)"error.breeder.longitude.required");
        return errors;
    }

    public Point getPoint() {
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate coordinate = new Coordinate(this.getLongitude(), this.getLatitude());
        return geometryFactory.createPoint(coordinate);
    }

    public void fromBean(Eleveur bean) {
        this.setTopiaId(bean.getTopiaId());
        this.setSociety(bean.getSociete().getTopiaId());
        this.setSocietyName(bean.getSociete().getCode());
        this.setCode(bean.getCode());
        this.setRaisonSociale(bean.getRaisonSociale());
        this.setTelephone(bean.getTelephone());
        this.setMobile(bean.getMobile());
        this.setAdresse(bean.getAdresse());
        this.setCodePostal(bean.getCodePostal());
        this.setVille(bean.getVille());
        this.setNiveauSecurite(SandraHelper.getWorstSecurityLevel((Eleveur)bean));
        this.setEmail(bean.getEmail());
        this.setCodeINSEE(bean.getCodeINSEE());
        this.setCommentaire(bean.getCommentaire());
        this.setContrainteHoraire(bean.getContrainteHoraire());
        this.setTomTomGPSLocked(bean.getNbTomTomGPSModif() > 3);
        this.setNotes(new ArrayList(bean.getNotes()));
        if (bean.getTomtomGPS() != null) {
            this.setLongitude(bean.getTomtomGPS().getPoint().getX());
            this.setLatitude(bean.getTomtomGPS().getPoint().getY());
        } else {
            this.setLatitude(0.0);
            this.setLongitude(0.0);
        }
        this.setAccesEleveur(bean.getAccesEleveur());
        this.setAccesSilos(bean.getActiveAccesSilo());
        this.setAccesTopiaId(bean.getAccesEleveur().getTopiaId());
        this.setAccesSilo(bean.getAccesEleveur().getAccesSilo());
        this.setCommentSecurite(bean.getAccesEleveur().getCommentaireSecurite());
        this.setModeChargement(bean.getAccesEleveur().getModeChargement());
        this.setAccessNiveauSecurite(bean.getAccesEleveur().getNiveauSecurite());
        this.setNomAccess(bean.getAccesEleveur().getNomAcces());
        this.risques = bean.getAccesEleveur().getRisques().toArray(new String[0]);
        this.setEtat(bean.getAccesEleveur().getEtat());
        this.setType(bean.getAccesEleveur().getType());
        this.setGps(bean.getAccesEleveur().getGps());
        this.setExistingGPS(bean.getAccesEleveur().getGps() != null);
    }

    public Eleveur toBean() {
        EleveurImpl bean = new EleveurImpl();
        bean.setRaisonSociale(this.getRaisonSociale());
        bean.setTopiaId(this.getTopiaId());
        bean.setCode(this.getCode());
        bean.setTelephone(this.getTelephone());
        bean.setMobile(this.getMobile());
        bean.setAdresse(this.getAdresse());
        bean.setCodePostal(this.getCodePostal());
        bean.setVille(this.getVille());
        bean.setEmail(this.getEmail());
        bean.setCodeINSEE(this.getCodeINSEE());
        bean.setContrainteHoraire(this.getContrainteHoraire());
        bean.setCommentaire(this.getCommentaire());
        SocieteImpl societe = new SocieteImpl();
        societe.setTopiaId(this.getSociety());
        bean.setSociete((Societe)societe);
        PointGPSImpl pointGPS = new PointGPSImpl();
        pointGPS.setPoint(this.getPoint());
        bean.setTomtomGPS((PointGPS)pointGPS);
        bean.setNotes((Collection)this.notes);
        InfoAccessImpl acces = new InfoAccessImpl();
        acces.setTopiaId(this.getAccesTopiaId());
        acces.setAccesSilo(this.getAccesSilo());
        acces.setCommentaireSecurite(this.getCommentSecurite());
        acces.setGps(this.getGps());
        acces.setModeChargement(this.getModeChargement());
        acces.setNiveauSecurite(this.getAccessNiveauSecurite());
        acces.setNomAcces(this.getNomAccess());
        acces.setRisques((Collection)this.getListRisques());
        acces.setEtat(this.getEtat());
        acces.setTrace(this.getTraceGPS());
        acces.setType(this.getType());
        bean.setAccesEleveur((InfoAccess)acces);
        return bean;
    }
}

