/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action;

import com.cybelia.sandra.web.action.UtilAction;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;

/*
 * Exception performing whole class analysis ignored.
 */
public class UtilAction {
    public static int getParameterInt(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new BadInputException("invalid.parameter.int", nfe, null);
        }
    }

    public static long getParameterLong(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw new BadInputException("invalid.parameter.long", nfe, null);
        }
    }

    public static boolean getParameterBoolean(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException nfe) {
            throw new BadInputException("invalid.parameter.boolean", nfe, null);
        }
    }

    public static String getParameterString(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        return value.trim();
    }

    public static boolean isEmptyParameter(HttpServletRequest request, String name) throws BadInputException {
        String value = request.getParameter(name);
        return StringUtils.isBlank((CharSequence)value);
    }

    public static boolean isNotEmptyParameter(HttpServletRequest request, String name) throws BadInputException {
        return !UtilAction.isEmptyParameter((HttpServletRequest)request, (String)name);
    }

    public static boolean checkRequiredField(HttpServletRequest request, ActionErrors errors, String field, String error) {
        if (StringUtils.isBlank((CharSequence)request.getParameter(field))) {
            errors.add(field, new ActionMessage(error));
            return false;
        }
        return true;
    }

    public static BufferedImage scale(BufferedImage source, int width, int height) {
        double sourceHeight = source.getHeight();
        double sourceWidth = source.getWidth();
        double ratio = sourceHeight / sourceWidth;
        if (sourceHeight < sourceWidth && sourceWidth > (double)width) {
            height = (int)((double)width * ratio);
        }
        if (sourceHeight > sourceWidth && sourceHeight > (double)height) {
            width = (int)((double)height / ratio);
        }
        BufferedImage buf = new BufferedImage(width, height, 1);
        Graphics2D g = buf.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return buf;
    }

    public static Integer checkIntegerField(HttpServletRequest request, ActionErrors errors, String field, String error) {
        Integer value;
        String tmp = request.getParameter(field);
        if (tmp == null) {
            return null;
        }
        try {
            value = Integer.parseInt(tmp.trim());
        }
        catch (NumberFormatException e) {
            errors.add(field, new ActionMessage(error));
            value = null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String propertiesPath) {
        InputStream stream = null;
        Properties data = null;
        try {
            stream = UtilAction.class.getResourceAsStream(propertiesPath);
            data = new Properties();
            data.load(stream);
        }
        catch (IOException ex) {
            Logger.getLogger(UtilAction.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(UtilAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return data;
    }
}

