/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web.action;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraConfigHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.util.ApplicationConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApplicationSession {
    protected static final Log log = LogFactory.getLog(ApplicationSession.class);
    public static final Class[] PROFIL_TYPES = new Class[]{Camion.class, Chauffeur.class, Eleveur.class, Societe.class, Transporteur.class, Usine.class};
    protected static MessageResources messages = MessageResources.getMessageResources((String)"sandra");
    protected String messageBienvenue;
    protected String copyright;
    protected String keyGoogleMap;
    protected String sandraVersion;
    protected Date previousRAZ;
    protected String msgFooter;
    protected TaasUser user;
    protected Map<String, String> namingSocietes = new LinkedHashMap();
    protected Map<String, String> namingTransporteurs = new LinkedHashMap();
    protected Map<String, String> namingCamions = new LinkedHashMap();
    protected Map<String, String> namingCamionsActif = new LinkedHashMap();
    protected Map<String, String> namingCamionsPrincipaux = new LinkedHashMap();
    protected Map<String, String> namingChauffeurs = new LinkedHashMap();
    protected Map<String, String> namingUsines = new LinkedHashMap();
    protected Map<String, String> namingEleveurs = new LinkedHashMap();
    protected Map<String, String> namingEvents = new LinkedHashMap();
    protected Map<String, String> namingUsers = new LinkedHashMap();
    protected Map<String, String> namingProfils = new LinkedHashMap();
    protected Map<String, String> namingRisques = new LinkedHashMap();
    protected Map<String, String> namingAcces = new LinkedHashMap();
    protected Map<String, String> namingEquipement = new LinkedHashMap();
    protected Map<String, String> namingTime = new LinkedHashMap();
    protected Map<String, String> namingActionType = new LinkedHashMap();
    protected Map<String, String> gpsState = new LinkedHashMap();
    protected Map<String, String> nivSecu = new LinkedHashMap();
    protected Map<String, String> operators = new LinkedHashMap();
    protected Map<String, String> namingLabels = new LinkedHashMap();
    protected List<Tour> cachedToursList = null;
    protected String cachedToursTopiaId = null;
    protected String cachedCamionTopiaId = null;
    protected Date cachedDebut = null;
    protected Date cachedFin = null;
    protected PaginedListImpl<Tour> listTours;
    protected List<String> templates;

    public static ApplicationSession get(HttpServletRequest request) throws Exception {
        return ApplicationSession.get((HttpSession)request.getSession());
    }

    public static ApplicationSession get(HttpSession session) throws Exception {
        ApplicationSession result = (ApplicationSession)session.getAttribute("applicationSession");
        if (result == null) {
            result = new ApplicationSession();
            session.setAttribute("applicationSession", (Object)result);
        }
        return result;
    }

    public List<Tour> getCachedToursList() {
        return this.cachedToursList;
    }

    public void setCachedToursList(List<Tour> cachedToursList) {
        this.cachedToursList = cachedToursList;
    }

    public String getCachedToursTopiaId() {
        return this.cachedToursTopiaId;
    }

    public void setCachedToursTopiaId(String cachedToursTopiaId) {
        this.cachedToursTopiaId = cachedToursTopiaId;
    }

    public String getCachedCamionTopiaId() {
        return this.cachedCamionTopiaId;
    }

    public void setCachedCamionTopiaId(String cachedCamionTopiaId) {
        this.cachedCamionTopiaId = cachedCamionTopiaId;
    }

    public Date getCachedDebut() {
        return this.cachedDebut;
    }

    public void setCachedDebut(Date cachedDebut) {
        this.cachedDebut = cachedDebut;
    }

    public Date getCachedFin() {
        return this.cachedFin;
    }

    public void setCachedFin(Date cachedFin) {
        this.cachedFin = cachedFin;
    }

    public PaginedListImpl<Tour> getListTours() {
        return this.listTours;
    }

    public void setListTours(PaginedListImpl<Tour> listTours) {
        this.listTours = listTours;
    }

    public String getMessageBienvenue() throws Exception {
        if (this.messageBienvenue == null) {
            ServiceWeb serviceWeb = ServiceFactory.newServiceWeb();
            this.messageBienvenue = serviceWeb.getMessageBienvenue(null);
        }
        return this.messageBienvenue;
    }

    public String getCopyright() throws Exception {
        if (this.copyright == null) {
            ServiceWeb serviceWeb = ServiceFactory.newServiceGuest();
            this.copyright = serviceWeb.getCopyright(null);
        }
        return this.copyright;
    }

    public String getGoogleMapKey() {
        if (this.keyGoogleMap == null) {
            this.keyGoogleMap = SandraConfigHelper.getGoogleMapKey((ApplicationConfig)SandraConfig.getConfig());
        }
        return this.keyGoogleMap;
    }

    public String getSandraVersion() {
        if (this.sandraVersion == null) {
            this.sandraVersion = SandraConfigHelper.getSandraVersion((ApplicationConfig)SandraConfig.getConfig());
        }
        return this.sandraVersion;
    }

    public Date getPreviousRAZ() {
        if (this.previousRAZ == null) {
            try {
                this.previousRAZ = SandraConfigHelper.getPreviousRAZDate((ApplicationConfig)SandraConfig.getConfig());
            }
            catch (ParseException eee) {
                log.info((Object)"Failed to load previous date of RAZ", (Throwable)eee);
            }
        }
        return this.previousRAZ;
    }

    public TaasUser getUser() throws Exception {
        if (this.user == null) {
            ServiceWeb serviceWeb = ServiceFactory.newServiceWeb();
            this.user = serviceWeb.getUser();
        }
        return this.user;
    }

    public String getFooterMsg() throws Exception {
        if (this.msgFooter == null) {
            this.msgFooter = "Sandra " + this.getSandraVersion() + " - " + this.getCopyright();
        }
        return this.msgFooter;
    }

    public Map<String, String> getNaming(Class<? extends TopiaEntity> klass) throws Exception {
        Cache cache = Cache.valueOf(klass);
        if (cache == null) {
            return null;
        }
        return cache.getCache(this);
    }

    public void clearNaming(Class<? extends TopiaEntity> klass) {
        Cache.valueOf(klass).clear(this);
    }

    public Map<String, String> getNamingSocietes() throws Exception {
        return Cache.Societe.getCache(this);
    }

    public Map<String, String> getNamingTransporteurs() throws Exception {
        return Cache.Transporteur.getCache(this);
    }

    public Map<String, String> getNamingCamions() throws Exception {
        return Cache.Camion.getCache(this);
    }

    public Map<String, String> getNamingCamionsActifs() throws Exception {
        return Cache.CamionActif.getCache(this);
    }

    public Map<String, String> getNamingCamionsPrincipaux() throws Exception {
        return Cache.CamionPrincipal.getCache(this);
    }

    public Map<String, String> getNamingChauffeurs() throws Exception {
        return Cache.Chauffeur.getCache(this);
    }

    public Map<String, String> getNamingUsines() throws Exception {
        return Cache.Usine.getCache(this);
    }

    public Map<String, String> getNamingEvents() throws Exception {
        return Cache.Event.getCache(this);
    }

    public Map<String, String> getNamingUsers() throws Exception {
        return Cache.User.getCache(this);
    }

    public Map<String, String> getNamingUserIndicateurs() throws Exception {
        return Cache.UserIndicateurs.getCache(this);
    }

    public Map<String, String> getNamingLabels() throws Exception {
        return Cache.Label.getCache(this);
    }

    public Map<String, String> getNamingLabelRisques() throws Exception {
        return MapUtils.orderedMap((Map)this.getNamingLabelByCategorie(this.namingRisques, "RSK"));
    }

    public Map<String, String> getNamingLabelAccessSilos() throws Exception {
        return this.getNamingLabelByCategorie(this.namingAcces, "IAS");
    }

    public Map<String, String> getNamingLabelEquipements() throws Exception {
        return this.getNamingLabelByCategorie(this.namingEquipement, "IMC");
    }

    public Map<String, String> getGpsStates() throws Exception {
        return this.getNamingLabelByCategorie(this.gpsState, "GPS");
    }

    public Map<String, String> getNivSecu() throws Exception {
        return this.getNamingLabelByCategorie(this.nivSecu, "NDS");
    }

    public Map<String, String> getOperators() throws Exception {
        return this.getNamingLabelByCategorie(this.operators, "OPE");
    }

    public Map<String, String> getNamingTime() throws Exception {
        return this.getNamingLabelByCategorie(this.namingTime, "ECH");
    }

    public Map<String, String> getNamingActionType() throws Exception {
        return this.getNamingLabelByCategorie(this.namingActionType, "ACT");
    }

    protected Map<String, String> getNamingLabelByCategorie(Map<String, String> naming, String categorie) throws Exception {
        if (naming.isEmpty()) {
            Map labels = Cache.Label.getCache(this);
            for (String key : labels.keySet()) {
                if (!key.matches("^" + categorie + "\\:.+$")) continue;
                String id = key.split(":")[1];
                naming.put(id, (String)labels.get(key));
            }
        }
        return naming;
    }

    public synchronized Map<String, String> getNamingProfils() {
        if (this.namingProfils.isEmpty()) {
            for (Class profilType : PROFIL_TYPES) {
                this.namingProfils.put(profilType.getName(), profilType.getSimpleName());
            }
        }
        return this.namingProfils;
    }

    public List<String> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<String> templates) {
        this.templates = templates;
    }
}

