/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.web;

import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceNotifier;
import com.cybelia.sandra.web.action.ServiceFactory;
import java.util.Date;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class SandraApplicationListener
implements ServletContextListener {
    protected static final Log log = LogFactory.getLog(SandraApplicationListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application starting at " + new Date() + "..."));
        }
        try {
            ServiceNotifier serviceNotifier = ServiceFactory.newServiceNotifier();
            serviceNotifier.init(null);
        }
        catch (Exception eee) {
            log.error((Object)"Failed to init notifier", (Throwable)eee);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application is ending at " + new Date() + "..."));
        }
        try {
            ServiceNotifier serviceNotifier = ServiceFactory.newServiceNotifier();
            serviceNotifier.notifyEvent("jbossHalt", new String[]{ServiceHelper.getSandraName(), ServiceHelper.getSandraUrl(), SandraHelper.convertDateToString((Date)new Date())});
        }
        catch (TopiaException eee) {
            log.error((Object)"Cant send jboss halt notification, caused by : ", (Throwable)eee);
        }
    }
}

