package com.cybelia.sandra.web.taglib;

import com.cybelia.sandra.web.action.ApplicationSession;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;

public class UserTagLib extends TagSupport {

    private static final long serialVersionUID = 1L;

    private TaasUser user;

    public void setUser(TaasUser user) {
        this.user = user;
    }

    private String method;

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public int doStartTag() throws JspException {
        try {
            JspWriter out = pageContext.getOut();

            if (method.equalsIgnoreCase("globalProfil")) {
                pageContext.setAttribute("isWeb", false);
                pageContext.setAttribute("isAdmin", false);
                Collection<TaasPrincipal> principals = user.getPrincipals();
                for (TaasPrincipal principal : principals) {
                    String name = principal.getName();
                    if (name.equals("web")) {
                        pageContext.setAttribute("isWeb", true);
                    } else if (name.startsWith("admin-")) {
                        pageContext.setAttribute("isAdmin", true);
                    }
                }
            } else if (method.equalsIgnoreCase("authorizations")) {
                HttpSession session = pageContext.getSession();
                ApplicationSession applicationSession = ApplicationSession.get(session);

                String profil = "";
                String profilAuthorizations = "";
                String adminProfil = "";

                Collection<TaasPrincipal> principals = user.getPrincipals();
                for (TaasPrincipal principal : principals) {
                    String name = principal.getName();
                    if (name.equals(user.getLogin())) {
                        Collection<TaasAuthorization> authorizations = principal.getAuthorizations();
                        for (TaasAuthorization authorization : authorizations) {
                            String expression = authorization.getExpression();
                            int actions = authorization.getActions();
                            if (!"*".equals(expression) && (actions & TaasUtil.LOAD) == TaasUtil.LOAD) {
                                Class<? extends TopiaEntity> klass = TopiaId.getClassName(expression);
                                Map<String, String> naming = applicationSession.getNaming(klass);
                                if (naming != null) {
                                    profilAuthorizations += " " + naming.get(expression);
                                }
                            }
                        }
                    } else if (name.startsWith("com.cybelia.sandra.entities")) {
                        profil = name.replace("com.cybelia.sandra.entities.", "");
                    } else if (name.equals("web")) {
                    } else if (name.startsWith("admin-")) {
                        adminProfil = "*";
                    }

                }
                if (!"".equals(profil)) {
                    out.print(profil + adminProfil + ":" + profilAuthorizations);
                }

            } else {
                out.print("??error??");
            }

        } catch (Exception e) {
            throw new JspException(e);
        }

        return SKIP_BODY;
    }
}
