package com.cybelia.sandra.web.taglib;


import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.StatutEnum;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.trace.CREtape;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.loading.model.LoadingTable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TourTagLib extends TagSupport {

    private static final long serialVersionUID = 1L;
    protected final Log log = LogFactory.getLog(getClass());

    public static String INCIDENT_ANOMALY = "tour.incident.anomaly";
    public static String INCIDENT_NOTHING = "tour.incident.nothing";
    public static String INCIDENT_ALLNOTHING = "tour.incident.allnothing";

    private Tour tour;

    public void setTour(Tour tour) {
        this.tour = tour;
    }

    private String method;

    public void setMethod(String method) {
        this.method = method;
    }

    private double round(double value) {
        return Math.round(value * 10.0) / 10.0;
    }

    @Override
    public int doStartTag() throws JspException {
        try {
            JspWriter out = pageContext.getOut();
            if (method.equalsIgnoreCase("driver")) {
                SuiviTour suiviTour = tour.getSuiviTour();
                Chauffeur chauffeur = null;
                if (suiviTour != null) {
                    chauffeur = suiviTour.getReel();
                    if (chauffeur == null) {
                        String nomPrenom = suiviTour.getChauffeurNomPrenom();
                        if (nomPrenom != null) {
                            out.print(nomPrenom);
                        }
                    }
                } else {
                    chauffeur = tour.getDefautChauffeur();
                }
                if (chauffeur != null) {
                    String nom = chauffeur.getNom();
                    if (nom != null) {
                        out.print(nom);
                        out.print(" ");
                    }

                    String prenom = chauffeur.getPrenom();
                    if (prenom != null) {
                        out.print(prenom);
                    }
                }
            } else if (method.equalsIgnoreCase("factories")) {
                SuiviTour suiviTour = tour.getSuiviTour();
                if (suiviTour != null) {
                    for (SuiviUsine suiviUsine : suiviTour.getSuiviUsines()) {
                        out.print(suiviUsine.getUsine().getCode() + " ");
                    }
                } else {
                    Set<String> usines = new HashSet<String>();
                    List<Etape> etapes = tour.getEtapes();
                    for (Etape etape : etapes) {
                        List<LigneProduit> produits = etape.getProduits();
                        for (LigneProduit produit : produits) {
                            String code = produit.getUsine().getCode();
                            usines.add(code);
                        }
                    }

                    for (String usine : usines) {
                        out.print(usine + " ");
                    }
                }

            } else if (method.equalsIgnoreCase("incident")) {
                SuiviTour suiviTour = tour.getSuiviTour();
                pageContext.setAttribute("tourIncident", INCIDENT_NOTHING);
                if (suiviTour != null) {
                    boolean ras = true;
                    for (SuiviEtape suiviEtape : suiviTour.getSuiviEtapes()) {
                        CREtape crEtape = suiviEtape.getCREtape();
                        if (crEtape != null) {
                            if (!"RAS".equalsIgnoreCase(crEtape.getLivraisonStatut().trim())) {
                                ras = false;
                                pageContext.setAttribute("tourIncident", INCIDENT_ANOMALY);
                            }
                        } else {
                            ras = false;
                        }
                    }
                    if (ras) {
                        pageContext.setAttribute("tourIncident", INCIDENT_ALLNOTHING);
                    }
                }

            } else if (method.equalsIgnoreCase("quantity")) {
                List<Etape> etapes = tour.getEtapes();
                int quantityTotal = 0;
                for (Etape etape : etapes) {
                    List<LigneProduit> ligneProduits = etape.getProduits();
                    for (LigneProduit ligneProduit : ligneProduits) {
                        quantityTotal = quantityTotal + ligneProduit.getQuantiteACharger();
                    }
                }
                // Arrondit à 1 nombre apres la virgule
                Double quantityTotalInTonne = new Double(quantityTotal) / 1000;
                quantityTotalInTonne = round(quantityTotalInTonne);
                // Exprimé en Tonne
                out.print(quantityTotalInTonne + "T ");

            } else if (method.equalsIgnoreCase("dateChargement")) {
                SuiviTour suiviTour = tour.getSuiviTour();
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                Date result = tour.getDateChargement();
                if (suiviTour != null) {
                    Date olderDate = null;
                    for (SuiviUsine suiviUsine : suiviTour.getSuiviUsines()) {
                        Date dateChargementPrevue = suiviUsine.getDateChargementPrevue();

                        // Date can not be inisialized (time = 0)
                        if ((olderDate == null || olderDate.after(dateChargementPrevue))
                                && dateChargementPrevue.getTime() > 0){
                            olderDate = dateChargementPrevue;
                        }
                    }

                    if (olderDate != null){
                        result = olderDate;
                    }
                }
                out.print(format.format(result));
            } else if (method.equalsIgnoreCase("status")) {
                StatutEnum statut = null;
                SuiviTour suiviTour = tour.getSuiviTour();
                List<LigneProduit> produits = new ArrayList<LigneProduit>();

                if (suiviTour != null) {
                    //tour en livraison
                    if (suiviTour.getStatus() == LoadingTable.TOUR_STATUS_DELIVERY) {
                        statut = StatutEnum.EN_COURS_LIVRAISON;
                    }

                    //tour termine
                    if (suiviTour.getStatus() == LoadingTable.TOUR_STATUS_TERMINED) {
                        statut = StatutEnum.TERMINE;
                    }

                    if (statut == null) {
                        List<SuiviEtape> suiviEtapes = suiviTour.getSuiviEtapes();
                        for (SuiviEtape suiviEtape : suiviEtapes) {
                            // En cas de mauvaise synchro, il se peut qu'il y a
                            // un suivi étape sans étape
                            Etape etape = suiviEtape.getEtape();
                            if (etape != null) {
                                produits.addAll(etape.getProduits());
                            }
                        }
                    }
                }
                List<Etape> etapes = tour.getEtapes();
                for (Etape etape : etapes) {
                    produits.addAll(etape.getProduits());
                }
                statut = getStatutSteps(produits);

                ApplicationSession applicationSession = ApplicationSession.get(pageContext.getSession());
                Map<String, String> naming = applicationSession.getNamingLabels();
                String nanming = naming.get("CHA:" + statut.getCode());
                out.print(nanming);

//                ResourceBundle bundle = ResourceBundle.getBundle("sandra");
//                String message = bundle.getString("loading.statut." + nanming);
//                out.print(" " + message);

            } else {
                out.print("??error??");
            }

        } catch (Exception e) {
            throw new JspException(e);
        }

        return SKIP_BODY;
    }

    private StatutEnum getStatutSteps(List<LigneProduit> produits) {
        StatutEnum statut = null;

        boolean oneAvailable = false; //un produit disponible
        boolean allAvailable = true; //tous les produits disponibles
        boolean oneCharged = false; //un produit charges

        for (LigneProduit produit : produits) {
            //calcul des statuts
            oneAvailable |= produit.getDisponible();
            allAvailable &= produit.getDisponible();
            oneCharged |= produit.getInfoChargement().getQuantite() > 0;
        }
        if (oneCharged) {
            statut = StatutEnum.CHARGE;
        } else if (allAvailable) {
            statut = StatutEnum.DISPONIBLE;
        } else if (oneAvailable) {
            statut = StatutEnum.SEMI_DISPONIBLE;
        } else {
            statut = StatutEnum.PLANIFIE;
        }

        return statut;
    }
}
