/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.cybelia.sandra.web.taglib;

import com.cybelia.sandra.entities.LigneProduit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.LogFactory;

/**
 * @author letellier
 */
public class ProductCommentIteratorTagLib extends TagSupport {

    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ProductCommentIteratorTagLib.class);

    protected List<LigneProduit> products;
    protected List<String> comments;
    protected int i;

    public void setProducts(List<LigneProduit> products) {
        this.products = products;
        comments = new ArrayList<String>();
        i = 0;
    }

    protected String nextComment() throws JspTagException {
        String comment = "";
        LigneProduit currentProduct = products.get(i);
        String currentComment = currentProduct.getCommande().getCommentaire();
        boolean unique = true;
        for (String c : comments) {
            if (c.trim().equals(currentComment.trim())) {
                unique = false;
            }
        }
        if (unique) {
            comment += currentComment;
        }
        comments.add(currentComment);
        i++;
        return comment;
    }

    protected boolean hasNext() throws JspTagException {
        return (i < products.size());
    }

    @Override
    public int doStartTag() throws JspTagException {
        int result = SKIP_BODY;
        if (hasNext()) {
            // pageContext.setAttribute("comment", nextComment());
            String currentComment = nextComment();
            JspWriter out = pageContext.getOut();
            try {
                out.println(currentComment);
            } catch (IOException ex) {
                log.error("Cant display comment : " + currentComment, ex);
            }
            result = EVAL_BODY_AGAIN;
        }
        return result;
    }

    @Override
    public int doAfterBody() throws JspTagException {
        return doStartTag();
    }

}
