package com.cybelia.sandra.web.taglib;

import com.cybelia.sandra.web.action.ApplicationSession;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * @author chemit
 */
public class LabelTagLib extends TagSupport {

    private static final long serialVersionUID = 1L;

    private String categorie;
    private String id;

    private String var;

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setVar(String var) {
        this.var = var;
    }

    @Override
    public int doStartTag() throws JspException {

        try {
            ApplicationSession applicationSession = ApplicationSession.get(pageContext.getSession());
            if (id == null || id.trim().isEmpty()) {
                return SKIP_BODY;
            }
            
            Map<String, String> naming = applicationSession.getNamingLabels();

            String key = id;
            if (categorie != null && !categorie.trim().isEmpty()) {
                key = categorie + ":" + id;
            }

            String value = naming.get(key);
            if (value == null) {
                value = "???" + key + "???";
            }
            if (var != null && !var.isEmpty()) {
                pageContext.setAttribute(var, value);
            } else {
                JspWriter out = pageContext.getOut();
                out.print(value);
            }

        } catch (Exception e) {
            throw new JspException(e);
        }

        return SKIP_BODY;
    }

    @Override
    public void release() {
        super.release();
        categorie = id = var = null;

    }
}
