package com.cybelia.sandra.web.taglib;

import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.Eleveur;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class BreederTagLib extends TagSupport {

    private static final long serialVersionUID = 1L;

    private Eleveur eleveur;

    public void setEleveur(Eleveur eleveur) {
        this.eleveur = eleveur;
    }

    private String method;

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public int doStartTag() throws JspException {
        try {
            JspWriter out = pageContext.getOut();

            if (method.equalsIgnoreCase("title")) {
                if (eleveur != null) {

                    out.print(SandraHelper.getEleveurTitle(eleveur));
                }
            } else {
                out.print("??error??");
            }

        } catch (Exception e) {
            throw new JspException(e);
        }

        return SKIP_BODY;
    }
}
