package com.cybelia.sandra.web.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.util.MessageResources;

/**
 * @author chemit
 */
public class BooleanDecoratorTagLib extends TagSupport {


    protected static MessageResources messages = MessageResources.getMessageResources("sandra");

    private static final long serialVersionUID = 1L;

    private Boolean value;

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public int doStartTag() throws JspException {

        if (value != null) {
            try {
                JspWriter out = pageContext.getOut();
                out.print(messages.getMessage(value ? "common.yes" : "common.no"));
            } catch (Exception e) {
                throw new JspException(e);
            }
        }

        return SKIP_BODY;
    }

    @Override
    public void release() {
        super.release();
        value = null;
    }

}
