package com.cybelia.sandra.web.displaytag;

import javax.servlet.http.HttpServletRequest;

/**
 * le contrat a respecter pour recuperer les donnees concrete de la liste a utiliser
 * dans {@link PaginedListImpl}.
 *
 * @author chemit
 */
public interface PaginedListExtractor<E> extends java.io.Serializable {

    /**
     * Obtenir la taille totale de liste non paginee.
     *
     * @param request la requete courante (utilisee pour pouvoir taper dans la session utilisateur)
     * @return la taille totale de la liste non paginee
     * @throws Exception if any pb
     */
    int getFullListSize(HttpServletRequest request) throws Exception;

    /**
     * Obtenir la liste triee et paginee.
     *
     * @param request       la requete courante (utilisee pour pouvoir taper dans la session utilisateur)
     * @param startIndex    la position du premier element a recupere (on commence a 0)
     * @param endIndex      le nombre d'elements a recuperer
     * @param sortCriterion la propriete de trie (null si pas de tri)
     * @param sortDirection la direction du tri : 1 pour descandant, 2 pour ascendant) @return la liste trie et pagine
     * @return la liste paginee et triee a afficher
     * @throws Exception if any pb
     */
    java.util.List<E> getList(HttpServletRequest request, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws Exception;

    /**
     * Obtenir un bean existant a partir de son identifiant technique unique.
     * <p/>
     * Note: <b>La methode doit declancher une exception si le bean n'existe pas.</b>
     *
     * @param topiaId l'identifiant technique unique du bean a recuperer depuis le service
     * @return le bean recupere
     * @throws Exception if any pb
     */
    E getBean(String topiaId) throws Exception;

}

