package com.cybelia.sandra.web.action.user;

import com.cybelia.sandra.web.action.UtilAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserImpl;

public class UserForm extends ActionForm {

    private static final long serialVersionUID = 1L;
    protected final transient Log log = LogFactory.getLog(getClass());

    protected String topiaId;
    protected String login;
    protected String email;
    protected boolean enabled;
    protected boolean isWeb;
    protected boolean isAdmin;
    protected boolean actif = true;
    protected String society; // Link in TaasUser
    protected String profilType;
    protected List<String> profils = new ArrayList<String>();
    protected String[] selectedProfils;

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getIsWeb() {
        return isWeb;
    }

    public void setIsWeb(boolean isWeb) {
        this.isWeb = isWeb;
    }

    public boolean getIsAdmin() {
        return isAdmin;
    }

    public void setIsAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public String getSociety() {
        return society;
    }

    public void setSociety(String society) {
        this.society = society;
    }

    public List<String> getProfils() {
        return profils;
    }

    public void addProfils(String topiaId) {
        this.profils.add(topiaId);
    }

    public void setProfils(List<String> profils) {
        this.profils = profils;
    }

    public void removeProfils(String topiaId) {
        this.profils.remove(topiaId);
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getProfilType() {
        return profilType;
    }

    public void setProfilType(String profilType) {
        this.profilType = profilType;
    }

    public String[] getSelectedProfils() {
        return selectedProfils;
    }

    public void setSelectedProfils(String[] currentprofils) {
        this.selectedProfils = currentprofils;
    }

    public boolean isActif() {
        return actif;
    }

    public void setActif(boolean actif) {
        this.actif = actif;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping,
                                 HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "login", "error.login.required");
        UtilAction.checkRequiredField(request, errors, "email", "error.email.required");
        UtilAction.checkRequiredField(request, errors, "society", "error.society.required");
        return errors;
    }

    public void fromBean(TaasUser user) {
        setTopiaId(user.getTopiaId());
        setLogin(user.getLogin());
        setEmail(user.getEmail());
        setEnabled(user.getEnabled());
        setSociety(user.getLink());
        setIsWeb(false);
        setIsAdmin(false);
        setProfilType(null);
        setProfils(new ArrayList<String>());

        Collection<TaasPrincipal> principals = user.getPrincipals();
        for (TaasPrincipal principal : principals) {
            String name = principal.getName();

            if (name.equals(user.getLogin())) {
                Collection<TaasAuthorization> authorizations = principal.getAuthorizations();
                for (TaasAuthorization authorization : authorizations) {
                    String expression = authorization.getExpression();
                    int actions = authorization.getActions();
                    if (!"*".equals(expression) && (actions & TaasUtil.LOAD) == TaasUtil.LOAD) {
                        addProfils(expression);
                    }
                }
            } else if (name.startsWith("com.cybelia.sandra.entities")) {
                setProfilType(name);
            } else if (name.equals("web")) {
                setIsWeb(true);
            } else if (name.startsWith("admin-")) {
                setIsAdmin(true);
            }
        }
    }

    public TaasUser toBean() {
        TaasUser user = new TaasUserImpl();
        user.setTopiaId(getTopiaId());
        user.setLogin(getLogin());
        user.setEmail(getEmail());
        user.setEnabled(getEnabled());
        user.setLink(getSociety());
        //user.setLink(user.getLink());
        return user;
    }
}
