package com.cybelia.sandra.web.action.tour;

import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.displaytag.AbstractPaginedListExtractor;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class ListTourTracabilityByBreeder extends ListTour {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        BreederCriteriaForm criteria = (BreederCriteriaForm) form;

        // get eleveur topiaId
        String breederTopiaId = ((BreederCriteriaForm) form).getBreederTopiaId();
        if (breederTopiaId == null && UtilAction.isNotEmptyParameter(request, "breederTopiaId")) {
            breederTopiaId = UtilAction.getParameterString(request, "breederTopiaId");
        }
        criteria.setBreederTopiaId(breederTopiaId);

        EtapeByBreederExtractor extractor = new EtapeByBreederExtractor(serviceWeb, criteria);

        // recuperation de la liste des tours paginee et triee
        PaginedListImpl<Pair<Etape, SuiviEtape>> listEtapes = new PaginedListImpl<Pair<Etape, SuiviEtape>>(extractor);
        // do not put default sort, service provide a default one (dateLivraison/camion.code/tour.numero);
        listEtapes.fromRequest(request).acquireData(request);

        // Recuperation des etapes
        StepsHelper.DefaultDataSteps defaultDataSteps = new StepsHelper.DefaultDataSteps();
        StepsHelper.DefaultDataSteps traceabilityDataSteps = new ListTourTraceability.TraceabilityDataSteps();
        StepsHelper.getStepsByEtapes(listEtapes.getList(), defaultDataSteps, traceabilityDataSteps);

        // postionnement des resultats dans la requete
        request.setAttribute("breeder", serviceWeb.getEleveur(null, breederTopiaId));
        request.setAttribute("steps", defaultDataSteps.getList());
        request.setAttribute("anomalies", traceabilityDataSteps.getList());
        request.setAttribute("criteriaByBreeder", criteria);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public static class EtapeByBreederExtractor extends AbstractPaginedListExtractor<Pair<Etape, SuiviEtape>> {

        private static final long serialVersionUID = 1L;

        protected BreederCriteriaForm criteria;

        protected EtapeByBreederExtractor(ServiceWeb service, BreederCriteriaForm criteria) {
            super(service);
            this.criteria = criteria;
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return service.getEtapesByEleveursCount(
                    null, criteria.getLivraisonDateStart(),
                    criteria.getLivraisonDateEnd(),
                    criteria.getBreederTopiaId());
        }

        public List<Pair<Etape, SuiviEtape>> getList(HttpServletRequest request, int startIndex,
                                  int endIndex, String sortCriterion,
                                  int sortDirection) throws Exception {
            /*if ( getFullListSize(request) == 0) {
                return null;
            }*/
            return service.getEtapesByEleveurs(
                    null, criteria.getLivraisonDateStart(),
                    criteria.getLivraisonDateEnd(),
                    criteria.getBreederTopiaId(),
                    startIndex, endIndex, sortCriterion, sortDirection);
        }

        public Pair<Etape, SuiviEtape> getBean(String topiaId) throws Exception {
            return service.getEtape(null, topiaId);
        }

        public void setCriteria(BreederCriteriaForm criteria) {
            this.criteria = criteria;
        }
    }
}
