package com.cybelia.sandra.web.action.tour;

import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.tour.StepsHelper.DataStep;
import com.cybelia.sandra.web.action.tour.StepsHelper.DefaultDataSteps;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ListTourStep extends ListTour {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
                                 HttpServletRequest request, HttpServletResponse response,
                                 ApplicationSession applicationSession, ServiceWeb serviceWeb)
            throws Exception {

        // Recuperation des tours
        super.execute(mapping, form, request, response, applicationSession, serviceWeb);

        // On recupere le filtre
        CriteriaForm criteria = (CriteriaForm) form;

        if (UtilAction.isNotEmptyParameter(request, "tour")) {
            // on recupere le filtre a partir de son identifiant
            String cachedToursTopiaId = request.getParameter("tour").trim();
            Tour t = serviceWeb.getTour(null, cachedToursTopiaId);

            applicationSession.setCachedToursTopiaId(cachedToursTopiaId);

            // On recupere les dates du filtre
            Date debut = criteria.getDateStart();
            Date fin = criteria.getDateEnd();

            // Recuperation du topiaId du camion
            String camionTopiaId = t.getCamion().getTopiaId();

            if (log.isDebugEnabled()) {
                log.debug("Debut : " + debut + " fin : " + fin + " camionTopiaId " + camionTopiaId);
            }

            // Get cached values
            List<Tour> cachedToursList = applicationSession.getCachedToursList();
            String cachedCamionTopiaId = applicationSession.getCachedCamionTopiaId();
            Date cachedDebut = applicationSession.getCachedDebut();
            Date cachedFin = applicationSession.getCachedFin();

            // Test si le rechargement est necessaire
            if (cachedToursList == null || !(cachedCamionTopiaId.equals(camionTopiaId) && cachedDebut.equals(debut) && cachedFin.equals(fin))) {

                // On recupere les tours du camion pour le numéro entre les dates du filtre
                List<Tour> toursList = serviceWeb.getToursByCamionAndDates(null, camionTopiaId, debut, fin);

                // Mise en cache
                applicationSession.setCachedCamionTopiaId(camionTopiaId);
                applicationSession.setCachedDebut(debut);
                applicationSession.setCachedFin(fin);
                applicationSession.setCachedToursList(toursList);

                // Navigation dans les tours
                request.setAttribute("toursNav", toursList);
            } else {
                // Navigation dans les tours
                request.setAttribute("toursNav", cachedToursList);
            }
            PaginedListImpl<Tour> tours = getTours(request);

            // Positionnement dans la requete des etapes
            request.setAttribute("steps", getStepsList(tours));
        }

        if (UtilAction.isEmptyParameter(request, "steps")) {
            // Recuperation de toutes les etapes correspondant a la recherche
            request.setAttribute("steps", getStepsList(applicationSession.getListTours()));
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    protected List<DataStep> getStepsList(PaginedListImpl<Tour> tours) {
        DefaultDataSteps dataSteps = new DefaultDataSteps();
        StepsHelper.getSteps(tours.getList(), dataSteps);
        return dataSteps.getList();
    }
}
