package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.web.action.UtilAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

/**
 * @author chemit
 */
public class UsineForm extends AbstractRefForm<Usine> {

    private static final long serialVersionUID = 1L;

    protected String adresse;
    protected String codePostal;
    protected String ville;

    public String getAdresse() {
        return adresse;
    }

    public String getCodePostal() {
        return codePostal;
    }

    public String getVille() {
        return ville;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public void setCodePostal(String codePostal) {
        this.codePostal = codePostal;
    }

    public void setVille(String ville) {
        this.ville = ville;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        topiaId = null;
        code = null;
        adresse = null;
        codePostal = null;
        ville = null;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "code", "error.factory.code.required");
        UtilAction.checkRequiredField(request, errors, "adresse", "error.factory.adresse.required");
        UtilAction.checkRequiredField(request, errors, "codePostal", "error.factory.codePostal.required");
        UtilAction.checkRequiredField(request, errors, "ville", "error.factory.ville.required");

        return errors;
    }

    public void fromBean(Usine bean) {
        setTopiaId(bean.getTopiaId());
        setCode(bean.getCode());
        setAdresse(bean.getAdresse());
        setCodePostal(bean.getCodePostal());
        setVille(bean.getVille());
    }

    public Usine toBean() {
        Usine bean = new com.cybelia.sandra.entities.UsineImpl();
        bean.setTopiaId(getTopiaId());
        bean.setCode(getCode());
        bean.setAdresse(getAdresse());
        bean.setCodePostal(getCodePostal());
        bean.setVille(getVille());
        return bean;
    }

}
