package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.ApplicationSession.Cache;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuiton.topia.TopiaException;

/**
 * Classe pour gerer les {@link Usine}.
 *
 * @author chemit
 */

public class UsineAction extends AbstractRefAction<Usine, UsineForm> {

    public UsineAction() {
        super(Usine.class, UsinePaginedListExtractor.class);
    }

    @Override
    protected PaginedListImpl<Usine> getPaginedList(String name, HttpServletRequest request, AbstractRefPaginedListExtractor<Usine> extractor) {
        PaginedListImpl<Usine> paginedList = super.getPaginedList(name, request, extractor);
        paginedList.setSortCriterion("code");
        return paginedList;
    }

    public static class UsinePaginedListExtractor extends AbstractRefPaginedListExtractor<Usine> {

        private static final long serialVersionUID = 3818166383606197935L;

        public UsinePaginedListExtractor(ServiceWeb service) {
            super(service);
        }

        public Usine getBean(String topiaId) throws LogicException, TopiaException {
            return service.getUsine(null, topiaId);
        }

        protected Usine saveBean(Usine bean) throws LogicException, TopiaException {
            return service.saveUsine(null, bean);
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return Cache.Usine.size(ApplicationSession.get(request));
        }

        public List<Usine> getList(HttpServletRequest request, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws Exception {
            return service.getUsines(null, startIndex, endIndex, sortCriterion, sortDirection);
        }
    }

}
