package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.web.action.UtilAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

/**
 * @author chemit
 */
public class LabelForm extends AbstractRefForm<Label> {

    private static final long serialVersionUID = 1L;

    protected String categorie;
    protected String id;
    protected String valeur;

    public String getCategorie() {
        return categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getValeur() {
        return valeur;
    }

    public void setValeur(String valeur) {
        this.valeur = valeur;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        topiaId = code = categorie = id = valeur = null;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "categorie", "error.label.categorie.required");
        UtilAction.checkRequiredField(request, errors, "id", "error.label.id.required");
        UtilAction.checkRequiredField(request, errors, "valeur", "error.label.valeur.required");

        return errors;
    }

    public void fromBean(Label bean) {
        setTopiaId(bean.getTopiaId());
        setCategorie(bean.getCategorie());
        setId(bean.getId());
        setValeur(bean.getValeur());
    }

    public Label toBean() {
        Label bean = new com.cybelia.sandra.entities.LabelImpl();
        bean.setTopiaId(getTopiaId());
        bean.setCategorie(getCategorie());
        bean.setId(getId());
        bean.setValeur(getValeur());
        return bean;
    }

}

