package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.ApplicationSession.Cache;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;

/**
 * @author chemit
 */
public class LabelAction extends AbstractRefAction<Label, LabelForm> {

    public LabelAction() {
        super(Label.class, LabelPaginedListExtractor.class);
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form,
                                HttpServletRequest request, HttpServletResponse response,
                                ServiceWeb serviceWeb, AbstractRefPaginedListExtractor<Label> extractor) throws Exception {

        // get label topiaId
        String topiaId = request.getParameter("topiaId");

        if (StringUtils.isNotBlank(topiaId)) {

            serviceWeb.deleteLabel(null, topiaId);
            // recompute cache
            ApplicationSession.Cache.Label.clear(ApplicationSession.get(request));

        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public static class LabelPaginedListExtractor extends AbstractRefPaginedListExtractor<Label> {

        private static final long serialVersionUID = 3818166383606197935L;

        public LabelPaginedListExtractor(ServiceWeb service) {
            super(service);
        }

        public Label getBean(String topiaId) throws LogicException, TopiaException {
            return service.getLabel(null, topiaId);
        }

        protected Label saveBean(Label bean) throws LogicException, TopiaException {
            return service.saveLabel(null, bean);
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return Cache.Label.size(ApplicationSession.get(request));
        }

        public List<Label> getList(HttpServletRequest request, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws Exception {
            return service.getLabels(null, startIndex, endIndex, sortCriterion, sortDirection);
        }
    }
}
