package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.web.action.UtilAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

/**
 * Le formulaire d'edition
 */
public class ChauffeurForm extends AbstractRefForm<Chauffeur> {

    private static final long serialVersionUID = 1L;
    protected String nom;
    protected String prenom;
    protected String trigramme;
    protected String societeId;
    protected String[] selectedCamions;

    public String getNom() {
        return nom;
    }

    public String getPrenom() {
        return prenom;
    }

    public String getTrigramme() {
        return trigramme;
    }

    public String getSocieteId() {
        return societeId;
    }

    public String[] getSelectedCamions() {
        return selectedCamions;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void setPrenom(String prenom) {
        this.prenom = prenom;
    }

    public void setTrigramme(String trigramme) {
        this.trigramme = trigramme;
    }

    public void setSocieteId(String societeId) {
        this.societeId = societeId;
    }

    public void setSelectedCamions(String[] selectedCamions) {
        this.selectedCamions = selectedCamions;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        topiaId = code = nom = prenom = trigramme = societeId = null;
        selectedCamions = null;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "code", "error.chauffeur.code.required");
        UtilAction.checkRequiredField(request, errors, "nom", "error.chauffeur.nom.required");
        UtilAction.checkRequiredField(request, errors, "prenom", "error.chauffeur.prenom.required");
        UtilAction.checkRequiredField(request, errors, "trigramme", "error.chauffeur.trigramme.required");
        UtilAction.checkRequiredField(request, errors, "societeId", "error.chauffeur.societeId.required");
        //TODO test trigramme
        return errors;
    }

    public void fromBean(Chauffeur bean) {
        setTopiaId(bean.getTopiaId());
        setCode(bean.getCode());
        setNom(bean.getNom());
        setPrenom(bean.getPrenom());
        setTrigramme(bean.getTrigramme());

        setSocieteId(bean.getSociete().getTopiaId());
    }

    public Chauffeur toBean() {
        Chauffeur bean = new com.cybelia.sandra.entities.ChauffeurImpl();
        bean.setTopiaId(getTopiaId());
        bean.setCode(getCode());
        bean.setNom(getNom());
        bean.setPrenom(getPrenom());
        bean.setTrigramme(getTrigramme());

        Societe societe = new com.cybelia.sandra.entities.SocieteImpl();
        societe.setTopiaId(getSocieteId());
        bean.setSociete(societe);

        return bean;
    }
}
