package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.ApplicationSession.Cache;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;

/**
 * Classe pour gerer les {@link com.cybelia.sandra.entities.Chauffeur}.
 *
 * @author chemit
 */
public class ChauffeurAction extends AbstractRefAction<Chauffeur, ChauffeurForm> {

    public ChauffeurAction() {
        super(Chauffeur.class, ChauffeurPaginedListExtractor.class);
    }

    // surcharge de l'action edition (pour recuperer les camions en mode update)
    public ActionForward view(ActionMapping mapping, ChauffeurForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb, ChauffeurPaginedListExtractor extractor) throws Exception {
        ActionForward forward = super.view(mapping, form, request, response, serviceWeb, extractor);

        // recuperation du code du chauffeur
        String topiaId = request.getParameter("topiaId");

        if (StringUtils.isNotBlank(topiaId)) {
            // mode mise a jour, donc on recupere les camions aussi les camions du chauffeur 
            Chauffeur b = extractor.getBean(topiaId);
            Collection<Camion> camions = b.getCamions();
            request.setAttribute("camions", camions == null ? java.util.Collections.EMPTY_LIST : camions);
        }
        // on effectue toujours un reset sur la selection des camions car en entrant ici,
        // on peut arriver des actions addCamions et deleteCamions et on ne veut pas conserver
        // l'ancienne selection
        form.setSelectedCamions(null);
        return forward;
    }

    // action ajout de camions
    public ActionForward addCamions(ActionMapping mapping, ChauffeurForm form,
                                    HttpServletRequest request, HttpServletResponse response,
                                    ServiceWeb serviceWeb, ChauffeurPaginedListExtractor extractor) throws Exception {
        //ChauffeurForm form = getForm(form);
        String[] ids = form.getSelectedCamions();
        if (ids != null && ids.length > 0) {
            serviceWeb.addCamionsToChauffeur(null, form.getTopiaId(), ids);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("no camion selected to be added to chauffeur " + form.getTopiaId());
            }
        }
        // on propage le code du chauffeur
        request.setAttribute("code", form.getCode());
        return mapping.findForward(SUCCESS_FORWARD);
    }

    // action suppression de camions
    public ActionForward deleteCamions(ActionMapping mapping, ChauffeurForm form,
                                       HttpServletRequest request, HttpServletResponse response,
                                       ServiceWeb serviceWeb, ChauffeurPaginedListExtractor extractor) throws Exception {
        //ChauffeurForm form = getForm(form);
        String[] ids = form.getSelectedCamions();
        if (ids != null && ids.length > 0) {
            serviceWeb.deleteCamionsToChauffeur(null, form.getTopiaId(), ids);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("no camion selected to be deleted to chauffeur " + form.getTopiaId());
            }
        }
        // on propage le code du chauffeur
        request.setAttribute("code", form.getCode());
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public static class ChauffeurPaginedListExtractor extends AbstractRefPaginedListExtractor<Chauffeur> {

        private static final long serialVersionUID = 3818166383606197935L;

        public ChauffeurPaginedListExtractor(ServiceWeb service) {
            super(service);
        }

        public Chauffeur getBean(String topiaId) throws LogicException, TopiaException {
            return service.getChauffeur(null, topiaId);
        }

        protected Chauffeur saveBean(Chauffeur bean) throws LogicException, TopiaException {
            return service.saveChauffeur(null, bean);
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return Cache.Chauffeur.size(ApplicationSession.get(request));
        }

        public List<Chauffeur> getList(HttpServletRequest request, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws Exception {
            return service.getChauffeurs(null, startIndex, endIndex, sortCriterion, sortDirection);
        }
    }

}
