package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.ApplicationSession.Cache;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;

/**
 * Action pour gerer les {@link Camion}.
 *
 * @author chemit
 */
public class CamionAction extends AbstractRefAction<Camion, CamionForm> {

    public CamionAction() {
        super(Camion.class, CamionPaginedListExtractor.class);
    }

    public ActionForward view(ActionMapping mapping, CamionForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, CamionPaginedListExtractor extractor) throws Exception {
        ActionForward forward = super.view(mapping, form, request, response, serviceWeb, extractor);
        String id = form.getTopiaId();
        if (StringUtils.isNotBlank(id)) {
            // camion deja existant, on recherche son camion principal
            Camion camionPrincipal = serviceWeb.getCamionPrincipal(null, id);
            if (log.isDebugEnabled()) {
                log.debug("obtain camion principal for [" + id + "] : " + (camionPrincipal == null ? null : camionPrincipal.getCode()));
            }
            form.setCamionPrincipal(camionPrincipal);
        }
        return forward;
    }

    public ActionForward save(ActionMapping mapping, CamionForm form, HttpServletRequest request, HttpServletResponse response, ServiceWeb serviceWeb, CamionPaginedListExtractor extractor) throws Exception {
        ActionForward forward = super.save(mapping, form, request, response, serviceWeb, extractor);

        String camionPrincipalId = form.getCamionPrincipalId();
        if (StringUtils.isNotBlank(camionPrincipalId)) {
            // le camion a un camion principal
            String camionId = form.getTopiaId();
            if (log.isDebugEnabled()) {
                log.debug("camion " + camionId + " has a principal camion " + camionPrincipalId);
            }
            serviceWeb.addCamionToCamionPrincipal(null, camionId, camionPrincipalId);
            // recompute cache
            Cache.Camion.clear(ApplicationSession.get(request));
        }
        return forward;
    }

    @Override
    protected PaginedListImpl<Camion> getPaginedList(String name, HttpServletRequest request, AbstractRefPaginedListExtractor<Camion> extractor) {
        PaginedListImpl<Camion> paginedList = super.getPaginedList(name, request, extractor);
        paginedList.setSortCriterion("code");
        return paginedList;
    }

    public static class CamionPaginedListExtractor extends AbstractRefPaginedListExtractor<Camion> {

        private static final long serialVersionUID = 3818166383606197935L;

        public CamionPaginedListExtractor(ServiceWeb service) {
            super(service);
        }

        public Camion getBean(String topiaId) throws LogicException, TopiaException {
            return service.getCamion(null, topiaId);
        }

        protected Camion saveBean(Camion bean) throws LogicException, TopiaException {
            return service.saveCamion(null, bean);
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return Cache.Camion.size(ApplicationSession.get(request));
        }

        public List<Camion> getList(HttpServletRequest request, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws Exception {
            return service.getCamions(null, null, true, startIndex, endIndex, sortCriterion, sortDirection);
        }
    }
}
