package com.cybelia.sandra.web.action.notifier;

import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.security.SecurityHelper;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.UtilAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.entities.TaasUser;

public class RecipientForm extends ActionForm {

    protected final transient Log log = LogFactory.getLog(getClass());

    protected String topiaId;
    protected String eventTopiaId;
    protected String label;

    /**
     * la liste des destinataires a traiter
     */
    protected String[] selected;

    protected transient List<String> frees;
    protected transient List<String> users;
    protected transient List<String> profils;

    protected transient List<String> availableUsers = new ArrayList<String>();
    protected String profilType;
    protected boolean isAdmin;
    protected transient List<String> availableProfils = new ArrayList<String>();

    private static final long serialVersionUID = 1L;

    public List<String> getAvailableUsers() {
        return availableUsers;
    }

    public void setAvailableUsers(List<String> availableUsers) {
        this.availableUsers = availableUsers;
    }

    public List<String> getAvailableProfils() {
        return availableProfils;
    }

    public void setAvailableProfils(List<String> availableProfils) {
        this.availableProfils = availableProfils;
    }

    public List<String> getFrees() {
        return frees;
    }

    public void setFrees(List<String> frees) {
        this.frees = frees;
    }

    public List<String> getProfils() {
        return profils;
    }

    public void setProfils(List<String> profils) {
        this.profils = profils;
    }

    public String[] getSelected() {
        return selected;
    }

    public void setSelected(String[] selected) {
        this.selected = selected;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public List<String> getUsers() {
        return users;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public String getEventTopiaId() {
        return eventTopiaId;
    }

    public void setEventTopiaId(String eventTopiaId) {
        this.eventTopiaId = eventTopiaId;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getProfilType() {
        return profilType;
    }

    public void setProfilType(String profilType) {
        this.profilType = profilType;
    }

    public boolean getIsAdmin() {
        return isAdmin;
    }

    public void setIsAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {

        ActionErrors errors = new ActionErrors();
        UtilAction.checkRequiredField(request, errors, "topiaId", "error.service.notifier.unfound");

        return errors;
    }

    public void fromBean(Cron cron, ApplicationSession applicationSession) throws Exception {
        setTopiaId(cron.getTopiaId());
        setEventTopiaId(cron.getEvent().getTopiaId());
        setLabel(cron.getLabel());

        users = new ArrayList<String>();
        profils = new ArrayList<String>();
        frees = new ArrayList<String>();

        for (String recipient : cron.getRecipients()) {
            String topiaId = SecurityHelper.getTopiaIdRecipient(recipient);
            if (TopiaId.isValidId(topiaId)) {
                if (TopiaId.getClassName(topiaId).isAssignableFrom(TaasUser.class)) {
                    users.add(recipient);
                } else {
                    profils.add(recipient);
                }
            } else {
                frees.add(recipient);
            }
        }

        availableUsers.clear();
        for (Entry<String, String> entry : applicationSession.getNamingUsers().entrySet()) {
            boolean free = true;
            String key = entry.getKey();
            for (Iterator<String> it = users.iterator(); free && it.hasNext();) {
                free = !it.next().equals(key);
            }
            if (free) {
                availableUsers.add(key);
            }
        }

        availableProfils.clear();
        if (profilType != null && !"".equals(profilType)) {
            Map<String, String> map = applicationSession.getNaming((Class<? extends TopiaEntity>) Class.forName(profilType));
            for (Entry<String, String> entry : map.entrySet()) {
                boolean free = true;
                String key = entry.getKey();
                for (Iterator<String> it = profils.iterator(); free && it.hasNext();) {
                    String element = it.next();
                    free = !element.equals(key) &&
                            !element.equals(SecurityHelper.getAdminProfilRecipient(key));
                }
                if (free) {
                    availableProfils.add(key);
                }
            }
        }

        // reset selection
        selected = null;
    }

}
