package com.cybelia.sandra.web.action.notifier;

import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.security.SecurityHelper;
import com.cybelia.sandra.services.ServiceNotifier;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.ServiceFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RecipientAction extends CommonMappingDispatchAction {

    @Override
    protected Object[] getArgs(ActionMapping mapping, ActionForm form,
                               HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, ApplicationSession.get(request), ServiceFactory.newServiceNotifier()};
    }

    public ActionForward view(ActionMapping mapping, RecipientForm form,
                              HttpServletRequest request, ApplicationSession applicationSession,
                              ServiceNotifier serviceNotifier) throws Exception {

        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank(topiaId)) {

            Cron cron = serviceNotifier.getCron(null, topiaId);
            form.fromBean(cron, ApplicationSession.get(request));
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward add(ActionMapping mapping, RecipientForm form,
                             HttpServletRequest request, ApplicationSession applicationSession,
                             ServiceNotifier serviceNotifier)
            throws Exception {

        String topiaId = form.getTopiaId();
        if (StringUtils.isNotBlank(topiaId)) {

            String[] recipients = form.getSelected();
            if (recipients != null) {
                for (String recipient : recipients) {
                    if (form.getIsAdmin()) {
                        serviceNotifier.saveRecepient(null, topiaId, SecurityHelper.getAdminProfilRecipient(recipient));
                    } else {
                        serviceNotifier.saveRecepient(null, topiaId, recipient);
                    }
                }
            }
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward delete(ActionMapping mapping, RecipientForm form,
                                HttpServletRequest request, ApplicationSession applicationSession,
                                ServiceNotifier serviceNotifier)
            throws Exception {

        String topiaId = form.getTopiaId();
        if (StringUtils.isNotBlank(topiaId)) {

            String[] recipients = form.getSelected();
            if (recipients != null) {
                for (String recipient : recipients) {
                    serviceNotifier.deleteRecipient(null, topiaId, recipient);
                }
            }
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

}
