package com.cybelia.sandra.web.action.notifier;

import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.services.ServiceNotifier;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.displaytag.PaginedListExtractor;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CronAction extends CommonMappingDispatchAction {

    @Override
    protected Object[] getArgs(ActionMapping mapping, ActionForm form,
                               HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, ApplicationSession.get(request), ServiceFactory.newServiceNotifier()};
    }

    public ActionForward list(ActionMapping mapping, CronForm form,
                              HttpServletRequest request, ApplicationSession applicationSession,
                              ServiceNotifier serviceNotifier) throws Exception {

        PaginedListExtractor<Cron> extractor = new CronPaginedListExtractor(serviceNotifier);
        PaginedListImpl<Cron> list = new PaginedListImpl<Cron>(extractor);
        list.setSortCriterion("label");
        request.setAttribute("beans", list.fromRequest(request).acquireData(request));

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward selectEvent(ActionMapping mapping, CronForm form,
                                     HttpServletRequest request, ApplicationSession applicationSession,
                                     ServiceNotifier serviceNotifier) throws Exception {

        String eventTopiaId = request.getParameter("eventTopiaId");
        if (StringUtils.isNotBlank(eventTopiaId)) {

            Event event = serviceNotifier.getEvent(null, eventTopiaId);

            form.setVariables(event.getVariables());
            form.setEventTopiaId(event.getTopiaId());

            String name = event.getType();
            form.setTemplateModel(name);
            form.setTemplateName(name);
            String content = serviceNotifier.getTemplate(name);
            form.setTemplateContent(content);
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward selectAuthor(ActionMapping mapping, CronForm form,
                                      HttpServletRequest request, ApplicationSession applicationSession,
                                      ServiceNotifier serviceNotifier) throws Exception {

        String authorTopiaId = request.getParameter("authorTopiaId");
        if (StringUtils.isNotBlank(authorTopiaId)) {

            form.setAuthorTopiaId(authorTopiaId);
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward selectTemplate(ActionMapping mapping, CronForm form,
                                        HttpServletRequest request, ApplicationSession applicationSession,
                                        ServiceNotifier serviceNotifier) throws Exception {

        String eventTopiaId = request.getParameter("eventTopiaId");
        if (StringUtils.isNotBlank(eventTopiaId)) {
            Event event = serviceNotifier.getEvent(null, eventTopiaId);
            form.setVariables(event.getVariables());
            form.setEventTopiaId(event.getTopiaId());
        }

        String name = form.getTemplateModel();
        form.setTemplateName(name);
        String content = "";
        if (StringUtils.isNotBlank(name)) {
            content = serviceNotifier.getTemplate(name);
        }
        form.setTemplateContent(content);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward view(ActionMapping mapping, CronForm form,
                              HttpServletRequest request, ApplicationSession applicationSession,
                              ServiceNotifier serviceNotifier) throws Exception {

        // Get notifier event if exists
        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank(topiaId)) {

            Cron cron = serviceNotifier.getCron(null, topiaId);
            String template = serviceNotifier.getTemplate(cron.getTemplate());
            form.fromBean(cron, template);
        }

        applicationSession.setTemplates(serviceNotifier.getTemplates());
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward save(ActionMapping mapping, CronForm form,
                              HttpServletRequest request, ApplicationSession applicationSession,
                              ServiceNotifier serviceNotifier) throws Exception {


        String content = form.getTemplateContent();
        String name = form.getTemplateName();
        if (StringUtils.isBlank(name)) {
            name = form.getTemplateModel();
        }
        serviceNotifier.saveTemplate(name, content);

        Cron cron = form.toBean();
        cron = serviceNotifier.saveCron(null, cron);
        form.fromBean(cron, content);

        applicationSession.setTemplates(serviceNotifier.getTemplates());
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward delete(ActionMapping mapping, CronForm form,
                                HttpServletRequest request, ApplicationSession applicationSession,
                                ServiceNotifier serviceNotifier)
            throws Exception {

        String topiaId = request.getParameter("topiaId");
        if (StringUtils.isNotBlank(topiaId)) {
            serviceNotifier.deleteCron(null, topiaId);
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    static class CronPaginedListExtractor implements PaginedListExtractor<Cron> {

        private static final long serialVersionUID = 1L;

        private final transient ServiceNotifier service;

        public CronPaginedListExtractor(ServiceNotifier serviceNotifier) {
            service = serviceNotifier;
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return service.getCronsCount(null);
        }

        public List<Cron> getList(HttpServletRequest request, int startIndex,
                                  int endIndex, String sortCriterion,
                                  int sortDirection) throws Exception {
            return service.getCrons(null, startIndex, endIndex, sortCriterion, sortDirection);
        }

        public Cron getBean(String topiaId) throws Exception {
            return service.getCron(null, topiaId);
        }

    }
}